/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sr.kernel;

import java.util.Collections;
import java.util.List;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.sched.Firing;
import ptolemy.actor.sched.NotSchedulableException;
import ptolemy.actor.sched.Schedule;
import ptolemy.actor.sched.Scheduler;
import ptolemy.actor.sched.StaticSchedulingDirector;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Workspace;

public class SRRandomizedScheduler
extends Scheduler {
    public SRRandomizedScheduler() {
    }

    public SRRandomizedScheduler(Workspace workspace) {
        super(workspace);
    }

    public SRRandomizedScheduler(Director container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    protected Schedule _getSchedule() throws NotSchedulableException {
        StaticSchedulingDirector director = (StaticSchedulingDirector)this.getContainer();
        if (director == null) {
            throw new NotSchedulableException(this, "SRRandomizedScheduler cannot schedule graph with no director.");
        }
        CompositeActor compositeActor = (CompositeActor)director.getContainer();
        if (compositeActor == null) {
            throw new NotSchedulableException(this, "SRRandomizedScheduler cannot schedule graph with no container.");
        }
        List actorList = compositeActor.deepEntityList();
        Collections.shuffle(actorList);
        Schedule schedule = new Schedule();
        for (Actor actor : actorList) {
            Firing firing = new Firing();
            firing.setActor(actor);
            schedule.add(firing);
        }
        return schedule;
    }
}

