/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sr.kernel;

import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.sched.Firing;
import ptolemy.actor.sched.NotSchedulableException;
import ptolemy.actor.sched.Schedule;
import ptolemy.actor.sched.Scheduler;
import ptolemy.actor.sched.StaticSchedulingDirector;
import ptolemy.actor.util.FunctionDependencyOfCompositeActor;
import ptolemy.graph.DirectedAcyclicGraph;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;
import ptolemy.util.MessageHandler;

public class SROptimizedScheduler
extends Scheduler {
    public SROptimizedScheduler() {
    }

    public SROptimizedScheduler(Workspace workspace) {
        super(workspace);
    }

    public SROptimizedScheduler(Director container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    protected Schedule _getSchedule() throws NotSchedulableException {
        StaticSchedulingDirector director = (StaticSchedulingDirector)this.getContainer();
        if (director == null) {
            throw new NotSchedulableException(this, "SROptimizedScheduler cannot schedule graph with no director.");
        }
        CompositeActor compositeActor = (CompositeActor)director.getContainer();
        if (compositeActor == null) {
            throw new NotSchedulableException(this, "SROptimizedScheduler cannot schedule graph with no container.");
        }
        FunctionDependencyOfCompositeActor functionDependency = (FunctionDependencyOfCompositeActor)compositeActor.getFunctionDependency();
        Object[] cycleNodes = functionDependency.getCycleNodes();
        if (cycleNodes.length != 0) {
            StringBuffer names = new StringBuffer();
            for (int i = 0; i < cycleNodes.length; ++i) {
                if (!(cycleNodes[i] instanceof Nameable)) continue;
                if (i > 0) {
                    names.append(", ");
                }
                names.append(((Nameable)cycleNodes[i]).getContainer().getFullName());
            }
            MessageHandler.error("There are strict cycle loops in the model:" + names.toString() + "\n" + " The results may contain unknowns.  This optimized " + "scheduler does not handle this model. Try the " + "randomized scheduler instead.");
        }
        DirectedAcyclicGraph dependencyGraph = functionDependency.getDetailedDependencyGraph().toDirectedAcyclicGraph();
        if (this._debugging) {
            this._debug("## dependency graph is:" + dependencyGraph.toString());
        }
        Object[] sort = dependencyGraph.topologicalSort();
        if (this._debugging) {
            this._debug("## Result of topological sort (highest depth to lowest):");
        }
        Schedule schedule = new Schedule();
        Actor lastActor = null;
        Actor actor = null;
        for (int i = 0; i < sort.length; ++i) {
            IOPort ioPort = (IOPort)sort[i];
            if (ioPort.isInput() && ioPort.numLinks() == 0 || (actor = (Actor)((Object)ioPort.getContainer())) == compositeActor) continue;
            if (lastActor == null) {
                lastActor = actor;
            } else {
                if (lastActor.equals(actor)) continue;
                lastActor = actor;
            }
            Firing firing = new Firing(actor);
            schedule.add(firing);
            if (!this._debugging) continue;
            this._debug(actor.getFullName(), "depth: " + i);
        }
        if (this._debugging) {
            this._debug("## End of topological sort.");
        }
        return schedule;
    }
}

