/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class UpSample
extends SDFTransformer {
    public Parameter factor = new Parameter(this, "factor");
    public Parameter phase;

    public UpSample(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.factor.setExpression("2");
        this.phase = new Parameter(this, "phase");
        this.phase.setExpression("factor-1");
        this.output_tokenProductionRate.setExpression("factor");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.factor) {
            int factorValue = ((IntToken)this.factor.getToken()).intValue();
            if (factorValue <= 0) {
                throw new IllegalActionException((Nameable)this, "Invalid factor: " + factorValue);
            }
        } else if (attribute == this.phase) {
            int phaseValue = ((IntToken)this.phase.getToken()).intValue();
            if (phaseValue < 0) {
                throw new IllegalActionException((Nameable)this, "Invalid phase: " + phaseValue);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        Token token = this.input.get(0);
        int factorValue = ((IntToken)this.factor.getToken()).intValue();
        int phaseValue = ((IntToken)this.phase.getToken()).intValue();
        if (phaseValue >= factorValue) {
            throw new IllegalActionException((Nameable)this, "Phase is out of range: " + phaseValue);
        }
        Token[] result = new Token[factorValue];
        Token zero = token.zero();
        for (int i = 0; i < factorValue; ++i) {
            result[i] = i == phaseValue ? token : zero;
        }
        this.output.send(0, result, factorValue);
    }
}

