/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.data.IntToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.MatrixType;
import ptolemy.data.type.MonotonicFunction;
import ptolemy.data.type.Type;
import ptolemy.domains.sdf.lib.SDFTransformer;
import ptolemy.graph.InequalityTerm;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class SequenceToMatrix
extends SDFTransformer {
    public Parameter rows;
    public Parameter columns;

    public SequenceToMatrix(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeAtLeast(new FunctionTerm(this.input));
        this.rows = new Parameter(this, "rows");
        this.rows.setExpression("1");
        this.columns = new Parameter(this, "columns");
        this.columns.setExpression("1");
        this.input_tokenConsumptionRate.setExpression("rows * columns");
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        int columnsValue;
        if (attribute == this.rows) {
            int rowsValue = ((IntToken)this.rows.getToken()).intValue();
            if (rowsValue <= 0) {
                throw new IllegalActionException((Nameable)this, "Invalid number of rows: " + rowsValue);
            }
        } else if (attribute == this.columns && (columnsValue = ((IntToken)this.columns.getToken()).intValue()) <= 0) {
            throw new IllegalActionException((Nameable)this, "Invalid number of columns: " + columnsValue);
        }
        super.attributeChanged(attribute);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        SequenceToMatrix newObject = (SequenceToMatrix)super.clone(workspace);
        newObject.output.setTypeAtLeast(new FunctionTerm(newObject.input));
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int rowsValue = ((IntToken)this.rows.getToken()).intValue();
        int columnsValue = ((IntToken)this.columns.getToken()).intValue();
        int length = rowsValue * columnsValue;
        Token[] valueArray = this.input.get(0, length);
        MatrixToken outputToken = MatrixToken.arrayToMatrix(this.input.getType(), valueArray, rowsValue, columnsValue);
        this.output.send(0, outputToken);
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        int columnsValue;
        int rowsValue = ((IntToken)this.rows.getToken()).intValue();
        int length = rowsValue * (columnsValue = ((IntToken)this.columns.getToken()).intValue());
        if (!this.input.hasToken(0, length)) {
            if (this._debugging) {
                this._debug("Called prefire(), which returns false.");
            }
            return false;
        }
        return super.prefire();
    }

    private static class FunctionTerm
    extends MonotonicFunction {
        private TypedIOPort _port;

        private FunctionTerm(TypedIOPort port) {
            this._port = port;
        }

        @Override
        public Object getValue() {
            Type inputType = this._port.getType();
            try {
                return MatrixType.getMatrixTypeForElementType(inputType);
            }
            catch (IllegalActionException ex) {
                return BaseType.UNKNOWN;
            }
        }

        @Override
        public InequalityTerm[] getVariables() {
            if (this._port.getTypeTerm().isSettable()) {
                InequalityTerm[] variable = new InequalityTerm[]{this._port.getTypeTerm()};
                return variable;
            }
            return new InequalityTerm[0];
        }
    }
}

