/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.sdf.kernel;

import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.Receiver;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.sched.NotSchedulableException;
import ptolemy.actor.sched.StaticSchedulingDirector;
import ptolemy.actor.util.DFUtilities;
import ptolemy.actor.util.Time;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.sdf.kernel.BaseSDFScheduler;
import ptolemy.domains.sdf.kernel.SDFReceiver;
import ptolemy.domains.sdf.kernel.SDFScheduler;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;

public class SDFDirector
extends StaticSchedulingDirector {
    public Parameter allowDisconnectedGraphs;
    public Parameter allowRateChanges;
    public Parameter constrainBufferSizes;
    public Parameter iterations;
    public Parameter period;
    public Parameter synchronizeToRealTime;
    public Parameter vectorizationFactor;
    protected int _iterationCount = 0;
    boolean _allowDisconnectedGraphs = false;
    private long _realStartTime = 0L;
    private int _vectorizationFactor = 1;

    public SDFDirector() throws IllegalActionException, NameDuplicationException {
        this._init();
    }

    public SDFDirector(Workspace workspace) throws IllegalActionException, NameDuplicationException {
        super(workspace);
        this._init();
    }

    public SDFDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this._init();
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        Token token;
        int newValue;
        if (attribute == this.allowDisconnectedGraphs) {
            Token token2 = this.allowDisconnectedGraphs.getToken();
            boolean newValue2 = ((BooleanToken)token2).booleanValue();
            if (newValue2 != this._allowDisconnectedGraphs) {
                this._allowDisconnectedGraphs = newValue2;
                this.invalidateSchedule();
            }
        } else if (attribute == this.vectorizationFactor && (newValue = ((IntToken)(token = this.vectorizationFactor.getToken())).intValue()) != this._vectorizationFactor) {
            this._vectorizationFactor = newValue;
            this.invalidateSchedule();
        }
        super.attributeChanged(attribute);
    }

    @Override
    public Time getModelNextIterationTime() {
        if (!this._isTopLevel()) {
            return super.getModelNextIterationTime();
        }
        try {
            double periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
            if (periodValue > 0.0) {
                return this.getModelTime().add(periodValue);
            }
            return this._currentTime;
        }
        catch (IllegalActionException exception) {
            throw new InternalErrorException(exception);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._iterationCount = 0;
        CompositeActor container = (CompositeActor)this.getContainer();
        for (IOPort port : container.outputPortList()) {
            int rate = DFUtilities.getTokenInitProduction(port);
            for (int i = 0; i < port.getWidthInside(); ++i) {
                try {
                    for (int k = 0; k < rate; ++k) {
                        Token t;
                        if (port.hasTokenInside(i)) {
                            t = port.getInside(i);
                            if (this._debugging) {
                                this._debug(this.getName(), "transferring output from " + port.getName());
                            }
                        } else {
                            throw new IllegalActionException((Nameable)this, port, "Port should produce " + rate + " tokens, but there were only " + k + " tokens available.");
                        }
                        port.send(i, t);
                    }
                    continue;
                }
                catch (NoTokenException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, null);
                }
            }
        }
        this._realStartTime = System.currentTimeMillis();
    }

    @Override
    public Receiver newReceiver() {
        return new SDFReceiver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean prefire() throws IllegalActionException {
        super.prefire();
        periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
        synchronizeValue = ((BooleanToken)this.synchronizeToRealTime.getToken()).booleanValue();
        if (periodValue > 0.0 && synchronizeValue) {
            var4_3 = this;
            synchronized (var4_3) {
                while (true) {
                    elapsedTime = System.currentTimeMillis() - this._realStartTime;
                    elapsedTimeInSeconds = (double)elapsedTime / 1000.0;
                    currentTime = this.getModelTime().getDoubleValue();
                    if (currentTime <= elapsedTimeInSeconds) {
                        break;
                    }
                    timeToWait = (long)((currentTime - elapsedTimeInSeconds) * 1000.0);
                    if (this._debugging) {
                        this._debug("Waiting for real time to pass: " + timeToWait);
                    }
                    try {
                        if (timeToWait <= 0L) continue;
                        this._workspace.wait(this, timeToWait);
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        container = (TypedCompositeActor)this.getContainer();
        inputPorts = container.inputPortList().iterator();
        while (true) {
            if (inputPorts.hasNext()) {
                inputPort = (IOPort)inputPorts.next();
                if (inputPort instanceof ParameterPort) continue;
                threshold = DFUtilities.getTokenConsumptionRate(inputPort);
                if (this._debugging) {
                    this._debug("checking input " + inputPort.getFullName());
                    this._debug("Threshold = " + threshold);
                }
            } else {
                if (this._debugging) {
                    this._debug("Director prefire returns true.");
                }
                return true;
            }
            channel = 0;
            while (true) {
                if (channel >= inputPort.getWidth()) ** break;
                if (threshold > 0 && !inputPort.hasToken(channel, threshold)) {
                    if (this._debugging) {
                        this._debug("Port " + inputPort.getFullName() + " does not have enough tokens: " + threshold + " Prefire returns false.");
                    }
                    return false;
                }
                ++channel;
            }
            break;
        }
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        BaseSDFScheduler scheduler = (BaseSDFScheduler)this.getScheduler();
        if (scheduler == null) {
            throw new IllegalActionException("Attempted to initialize SDF system with no scheduler");
        }
        if (this._debugging) {
            this._debug("Computing schedule");
        }
        try {
            scheduler.getSchedule();
        }
        catch (NotSchedulableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, ex, "Failed to compute schedule:");
        }
        scheduler.declareRateDependency();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        int iterationsValue = ((IntToken)this.iterations.getToken()).intValue();
        ++this._iterationCount;
        if (iterationsValue > 0 && this._iterationCount >= iterationsValue) {
            this._iterationCount = 0;
            return false;
        }
        double periodValue = ((DoubleToken)this.period.getToken()).doubleValue();
        if (periodValue > 0.0) {
            Actor container = (Actor)((Object)this.getContainer());
            Director executiveDirector = container.getExecutiveDirector();
            Time currentTime = this.getModelTime();
            if (executiveDirector != null) {
                executiveDirector.fireAt(container, currentTime.add(periodValue));
            } else {
                this.setModelTime(currentTime.add(periodValue));
            }
        }
        return super.postfire();
    }

    @Override
    public String[] suggestedModalModelDirectors() {
        return new String[]{"ptolemy.domains.fsm.kernel.FSMDirector", "ptolemy.domains.fsm.kernel.MultirateFSMDirector", "ptolemy.domains.hdf.kernel.HDFFSMDirector"};
    }

    @Override
    public boolean supportMultirateFiring() {
        return true;
    }

    @Override
    public boolean transferInputs(IOPort port) throws IllegalActionException {
        if (!port.isInput() || !port.isOpaque()) {
            throw new IllegalActionException((Nameable)this, port, "Attempted to transferInputs on a port is not an opaqueinput port.");
        }
        this.getScheduler().getSchedule();
        int rate = DFUtilities.getTokenConsumptionRate(port);
        boolean wasTransferred = false;
        for (int i = 0; i < port.getWidth(); ++i) {
            try {
                if (i < port.getWidthInside()) {
                    for (int k = 0; k < rate; ++k) {
                        Token t;
                        if (port.hasToken(i)) {
                            t = port.get(i);
                            if (this._debugging) {
                                this._debug(this.getName(), "transferring input from " + port.getName());
                            }
                        } else {
                            throw new IllegalActionException((Nameable)this, port, "Port should consume " + rate + " tokens, but there were only " + k + " tokens available.");
                        }
                        port.sendInside(i, t);
                        wasTransferred = true;
                    }
                    continue;
                }
                if (this._debugging) {
                    this._debug(this.getName(), "Dropping single input from " + port.getName());
                }
                if (!port.hasToken(i)) continue;
                port.get(i);
                continue;
            }
            catch (NoTokenException ex) {
                throw new InternalErrorException(this, (Throwable)ex, null);
            }
        }
        return wasTransferred;
    }

    @Override
    public boolean transferOutputs(IOPort port) throws IllegalActionException {
        if (this._debugging) {
            this._debug("Calling transferOutputs on port: " + port.getFullName());
        }
        if (!port.isOutput() || !port.isOpaque()) {
            throw new IllegalActionException((Nameable)this, port, "Attempted to transferOutputs on a port that is not an opaque input port.");
        }
        int rate = DFUtilities.getTokenProductionRate(port);
        boolean wasTransferred = false;
        for (int i = 0; i < port.getWidthInside(); ++i) {
            try {
                for (int k = 0; k < rate; ++k) {
                    Token t;
                    if (port.hasTokenInside(i)) {
                        t = port.getInside(i);
                        if (this._debugging) {
                            this._debug(this.getName(), "transferring output from " + port.getName());
                        }
                    } else {
                        throw new IllegalActionException((Nameable)this, port, "Port should produce " + rate + " tokens, but there were only " + k + " tokens available.");
                    }
                    port.send(i, t);
                    wasTransferred = true;
                }
                continue;
            }
            catch (NoTokenException ex) {
                throw new InternalErrorException(this, (Throwable)ex, null);
            }
        }
        return wasTransferred;
    }

    private void _init() throws IllegalActionException, NameDuplicationException {
        this.iterations = new Parameter(this, "iterations");
        this.iterations.setTypeEquals(BaseType.INT);
        this.iterations.setExpression("0");
        this.vectorizationFactor = new Parameter(this, "vectorizationFactor");
        this.vectorizationFactor.setTypeEquals(BaseType.INT);
        this.vectorizationFactor.setExpression("1");
        this.allowDisconnectedGraphs = new Parameter(this, "allowDisconnectedGraphs");
        this.allowDisconnectedGraphs.setTypeEquals(BaseType.BOOLEAN);
        this.allowDisconnectedGraphs.setExpression("false");
        this.allowRateChanges = new Parameter(this, "allowRateChanges");
        this.allowRateChanges.setTypeEquals(BaseType.BOOLEAN);
        this.allowRateChanges.setExpression("false");
        this.constrainBufferSizes = new Parameter(this, "constrainBufferSizes");
        this.constrainBufferSizes.setTypeEquals(BaseType.BOOLEAN);
        this.constrainBufferSizes.setExpression("true");
        this.period = new Parameter((NamedObj)this, "period", new DoubleToken(1.0));
        this.period.setTypeEquals(BaseType.DOUBLE);
        this.period.setExpression("0.0");
        this.synchronizeToRealTime = new Parameter(this, "synchronizeToRealTime");
        this.synchronizeToRealTime.setExpression("false");
        this.synchronizeToRealTime.setTypeEquals(BaseType.BOOLEAN);
        this.timeResolution.setVisibility(Settable.FULL);
        this.timeResolution.moveToLast();
        SDFScheduler scheduler = new SDFScheduler(this, this.uniqueName("Scheduler"));
        scheduler.constrainBufferSizes.setExpression("constrainBufferSizes");
        this.setScheduler(scheduler);
    }
}

