/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.pn.kernel;

import java.io.Writer;
import java.util.List;
import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.Manager;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.domains.pn.kernel.PNDirector;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class NondeterministicMerge
extends TypedCompositeActor {
    public TypedIOPort input;
    public TypedIOPort output;
    public TypedIOPort channel;

    public NondeterministicMerge(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this._constructor();
    }

    public NondeterministicMerge(Workspace workspace) throws NameDuplicationException, IllegalActionException {
        super(workspace);
        this._constructor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionsChanged(Port port) {
        super.connectionsChanged(port);
        if (port == this.input) {
            List containedActors = this.entityList();
            int numberOfContainedActors = containedActors.size();
            int inputWidth = this.input.getWidth();
            for (int i = 0; i < inputWidth; ++i) {
                Object localActor;
                if (i < numberOfContainedActors) {
                    localActor = containedActors.get(i);
                    Object e = localActor;
                    synchronized (e) {
                        localActor.notifyAll();
                    }
                    Director director = this.getExecutiveDirector();
                    if (director == null) continue;
                    Director director2 = director;
                    synchronized (director2) {
                        director.notifyAll();
                        continue;
                    }
                }
                try {
                    localActor = new ChannelActor(i, this);
                    Manager manager = this.getManager();
                    if (manager == null || manager.getState() == Manager.IDLE) continue;
                    manager.requestInitialization((Actor)localActor);
                    continue;
                }
                catch (KernelException e) {
                    throw new InternalErrorException(e);
                }
            }
        }
    }

    private void _constructor() throws NameDuplicationException, IllegalActionException {
        this.input = new TypedIOPort(this, "input", true, false);
        this.output = new TypedIOPort(this, "output", false, true);
        this.input.setMultiport(true);
        this.output.setTypeAtLeast(this.input);
        this.channel = new TypedIOPort(this, "channel");
        this.channel.setOutput(true);
        this.channel.setTypeEquals(BaseType.INT);
        StringAttribute channelCardinal = new StringAttribute(this.channel, "_cardinal");
        channelCardinal.setExpression("SOUTH");
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-10,20 10,10 10,-10, -10,-20\" style=\"fill:red\"/>\n</svg>\n");
        new MergeDirector(this, "director");
    }

    private class MergeDirector
    extends PNDirector {
        public MergeDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        @Override
        public synchronized void addThread(Thread thread) {
            Director director = NondeterministicMerge.this.getExecutiveDirector();
            if (!(director instanceof PNDirector)) {
                throw new InternalErrorException("NondeterministicMerge actor can only execute under the control of a PNDirector!");
            }
            ((PNDirector)director).addThread(thread);
        }

        @Override
        public void fire() {
        }

        @Override
        public boolean postfire() {
            return false;
        }

        @Override
        public synchronized void removeThread(Thread thread) {
            Director director = NondeterministicMerge.this.getExecutiveDirector();
            if (!(director instanceof PNDirector)) {
                throw new InternalErrorException("NondeterministicMerge actor can only execute under the control of a PNDirector!");
            }
            ((PNDirector)director).removeThread(thread);
        }

        @Override
        public synchronized void threadBlocked(Thread thread, ProcessReceiver receiver) {
            Director director = NondeterministicMerge.this.getExecutiveDirector();
            if (!(director instanceof PNDirector)) {
                throw new InternalErrorException("NondeterministicMerge actor can only execute under the control of a PNDirector!");
            }
            ((PNDirector)director).threadBlocked(thread, receiver);
        }

        @Override
        public synchronized void threadBlocked(Thread thread, ProcessReceiver receiver, boolean readOrWrite) {
            Director director = NondeterministicMerge.this.getExecutiveDirector();
            if (!(director instanceof PNDirector)) {
                throw new InternalErrorException("NondeterministicMerge actor can only execute under the control of a PNDirector!");
            }
            ((PNDirector)director).threadBlocked(thread, receiver, readOrWrite);
        }

        @Override
        public synchronized void threadHasPaused(Thread thread) {
            Director director = NondeterministicMerge.this.getExecutiveDirector();
            if (!(director instanceof PNDirector)) {
                throw new InternalErrorException("NondeterministicMerge actor can only execute under the control of a PNDirector!");
            }
            ((PNDirector)director).threadHasPaused(thread);
        }

        @Override
        public synchronized void threadHasResumed(Thread thread) {
            Director director = NondeterministicMerge.this.getExecutiveDirector();
            if (!(director instanceof PNDirector)) {
                throw new InternalErrorException("NondeterministicMerge actor can only execute under the control of a PNDirector!");
            }
            ((PNDirector)director).threadHasResumed(thread);
        }

        @Override
        public synchronized void threadUnblocked(Thread thread, ProcessReceiver receiver) {
            Director director = NondeterministicMerge.this.getExecutiveDirector();
            if (!(director instanceof PNDirector)) {
                throw new InternalErrorException("NondeterministicMerge actor can only execute under the control of a PNDirector!");
            }
            ((PNDirector)director).threadUnblocked(thread, receiver);
        }

        @Override
        public synchronized void threadUnblocked(Thread thread, ProcessReceiver receiver, boolean readOrWrite) {
            Director director = NondeterministicMerge.this.getExecutiveDirector();
            if (!(director instanceof PNDirector)) {
                throw new InternalErrorException("NondeterministicMerge actor can only execute under the control of a PNDirector!");
            }
            ((PNDirector)director).threadUnblocked(thread, receiver, readOrWrite);
        }

        @Override
        public void wrapup() {
        }

        @Override
        protected boolean _resolveDeadlock() {
            if (this._debugging) {
                this._debug("Deadlock is not real as NondeterministicMerge can't deadlock.");
            }
            return true;
        }
    }

    private class ChannelActor
    extends TypedAtomicActor {
        private int _channelIndex;
        private IntToken _channelValue;

        public ChannelActor(NondeterministicMerge container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
            this._channelIndex = 0;
            this._channelValue = new IntToken(this._channelIndex);
        }

        public ChannelActor(int index, NondeterministicMerge container) throws IllegalActionException, NameDuplicationException {
            super(container, "ChannelActor" + index);
            this._channelIndex = index;
            this._channelValue = new IntToken(this._channelIndex);
        }

        @Override
        public void exportMoML(Writer output, int depth, String name) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fire() throws IllegalActionException {
            if (NondeterministicMerge.this.input.getWidth() > this._channelIndex) {
                if (!NondeterministicMerge.this._stopRequested && NondeterministicMerge.this.input.hasToken(this._channelIndex)) {
                    if (this._debugging) {
                        NondeterministicMerge.this._debug("Waiting for input from channel " + this._channelIndex);
                    }
                    Token result = NondeterministicMerge.this.input.get(this._channelIndex);
                    Director director = ((NondeterministicMerge)this.getContainer()).getExecutiveDirector();
                    synchronized (director) {
                        NondeterministicMerge.this.output.send(0, result);
                        NondeterministicMerge.this.channel.send(0, this._channelValue);
                    }
                    if (this._debugging) {
                        NondeterministicMerge.this._debug("Sent " + result + " from channel " + this._channelIndex + " to the output.");
                    }
                }
            } else {
                ChannelActor channelActor = this;
                synchronized (channelActor) {
                    try {
                        this.workspace().wait(this);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public Manager getManager() {
            return NondeterministicMerge.this.getManager();
        }
    }
}

