/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.hdf.kernel;

import ptolemy.actor.CompositeActor;
import ptolemy.actor.TypedActor;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.MultirateFSMDirector;
import ptolemy.domains.fsm.kernel.State;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class HDFFSMDirector
extends MultirateFSMDirector {
    private boolean _sendRequest;

    public HDFFSMDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public void fire() throws IllegalActionException {
        CompositeActor container = (CompositeActor)this.getContainer();
        FSMActor controller = this.getController();
        controller.setNewIteration(this._sendRequest);
        this._readInputs();
        State currentState = controller.currentState();
        TypedActor[] actors = currentState.getRefinement();
        if (actors == null || actors.length != 1) {
            throw new IllegalActionException((Nameable)this, "Current state is required to have exactly one refinement: " + currentState.getName());
        }
        if (!this._stopRequested && actors[0].prefire()) {
            if (this._debugging) {
                this._debug(this.getFullName(), " fire refinement", ((NamedObj)((Object)actors[0])).getName());
            }
            actors[0].fire();
            this._refinementPostfire = actors[0].postfire();
        }
        this._readOutputsFromRefinement();
        if (this._sendRequest) {
            ChangeRequest request = new ChangeRequest(this, "choose a transition"){

                @Override
                protected void _execute() throws KernelException, IllegalActionException {
                    FSMActor controller = HDFFSMDirector.this.getController();
                    State currentState = controller.currentState();
                    HDFFSMDirector.this.chooseNextNonTransientState(currentState);
                }
            };
            request.setPersistent(false);
            container.requestChange(request);
        }
    }

    @Override
    public Entity getContext() {
        try {
            this._getEnclosingDomainActor();
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(ex);
        }
        return (Entity)this.toplevel();
    }

    @Override
    public void initialize() throws IllegalActionException {
        FSMActor controller = this.getController();
        this._sendRequest = true;
        controller.setNewIteration(this._sendRequest);
        super.initialize();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        CompositeActor container = (CompositeActor)this.getContainer();
        if (this._sendRequest) {
            this._sendRequest = false;
            ChangeRequest request = new ChangeRequest(this, "make a transition"){

                @Override
                protected void _execute() throws KernelException {
                    HDFFSMDirector.this._sendRequest = true;
                    HDFFSMDirector.this.makeStateTransition();
                }
            };
            request.setPersistent(false);
            container.requestChange(request);
        }
        return this._refinementPostfire;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        this._sendRequest = true;
        super.preinitialize();
    }
}

