/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.modal;

import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.modal.ModalModel;
import ptolemy.domains.fsm.modal.RefinementPort;
import ptolemy.kernel.ComponentRelation;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class ModalController
extends FSMActor {
    protected boolean _mirrorDisable = false;

    public ModalController(Workspace workspace) {
        super(workspace);
    }

    public ModalController(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public Port newPort(String name) throws NameDuplicationException {
        try {
            this._workspace.getWriteAccess();
            if (this._mirrorDisable || this.getContainer() == null) {
                RefinementPort port = new RefinementPort(this, name);
                ModalModel container = (ModalModel)this.getContainer();
                if (container != null) {
                    String relationName = name + "Relation";
                    ComponentRelation relation = container.getRelation(relationName);
                    if (relation == null) {
                        relation = container.newRelation(relationName);
                        Port containerPort = container.getPort(name);
                        containerPort.link(relation);
                    }
                    port.link(relation);
                }
                RefinementPort refinementPort = port;
                return refinementPort;
            }
            this._mirrorDisable = true;
            ((ModalModel)this.getContainer()).newPort(name);
            Port port = this.getPort(name);
            return port;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException("ModalController.newPort: Internal error: " + ex.getMessage());
        }
        finally {
            this._mirrorDisable = false;
            this._workspace.doneWriting();
        }
    }

    public void setMirrorDisable(boolean disable) {
        this._mirrorDisable = disable;
    }

    protected void _checkContainer(Entity container) throws IllegalActionException {
        if (!(container instanceof ModalModel) && container != null) {
            throw new IllegalActionException((Nameable)container, this, "ModalController can only be contained by ModalModel objects.");
        }
    }
}

