/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import ptolemy.actor.TypedActor;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.data.BooleanToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.ComponentPort;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class State
extends ComponentEntity {
    public ComponentPort incomingPort = null;
    public Parameter isFinalState;
    public Parameter isInitialState;
    public ComponentPort outgoingPort = null;
    public StringAttribute refinementName = null;
    private boolean _visited = false;
    private List _nonpreemptiveTransitionList = new LinkedList();
    private List _preemptiveTransitionList = new LinkedList();
    private TypedActor[] _refinement = null;
    private long _refinementVersion = -1L;
    private long _transitionListVersion = -1L;

    public State(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.incomingPort = new ComponentPort(this, "incomingPort");
        this.outgoingPort = new ComponentPort(this, "outgoingPort");
        this.refinementName = new StringAttribute(this, "refinementName");
        this._attachText("_iconDescription", "<svg>\n<circle cx=\"0\" cy=\"0\" r=\"20\" style=\"fill:white\"/>\n</svg>\n");
        SingletonParameter center = new SingletonParameter(this, "_centerName");
        center.setExpression("true");
        center.setVisibility(Settable.EXPERT);
        this.isInitialState = new Parameter(this, "isInitialState");
        this.isInitialState.setTypeEquals(BaseType.BOOLEAN);
        String initialStateName = "";
        if (container instanceof FSMActor) {
            initialStateName = ((FSMActor)container).initialStateName.getExpression().trim();
        }
        if (initialStateName.equals("")) {
            if (container.entityList(State.class).size() == 1) {
                this.isInitialState.setExpression("true");
            } else {
                this.isInitialState.setExpression("false");
            }
        } else if (initialStateName.equals(name)) {
            this.isInitialState.setExpression("true");
        } else {
            this.isInitialState.setExpression("false");
        }
        this.isFinalState = new Parameter(this, "isFinalState");
        this.isFinalState.setTypeEquals(BaseType.BOOLEAN);
        this.isFinalState.setExpression("false");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        NamedObj container;
        super.attributeChanged(attribute);
        if (attribute == this.refinementName) {
            this._refinementVersion = -1L;
        } else if (attribute == this.isInitialState && (container = this.getContainer()) instanceof FSMActor && ((BooleanToken)this.isInitialState.getToken()).booleanValue()) {
            if (((FSMActor)container)._initialState != null && ((FSMActor)container)._initialState != this) {
                ((FSMActor)container)._initialState.isInitialState.setToken("false");
            }
            ((FSMActor)container)._initialState = this;
            String name = ((FSMActor)container).initialStateName.getExpression();
            if (!name.equals("")) {
                ((FSMActor)container).initialStateName.setExpression("");
            }
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        State newObject = (State)super.clone(workspace);
        newObject.incomingPort = (ComponentPort)newObject.getPort("incomingPort");
        newObject.outgoingPort = (ComponentPort)newObject.getPort("outgoingPort");
        newObject.refinementName = (StringAttribute)newObject.getAttribute("refinementName");
        newObject._refinementVersion = -1L;
        newObject._transitionListVersion = -1L;
        newObject._nonpreemptiveTransitionList = new LinkedList();
        newObject._preemptiveTransitionList = new LinkedList();
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypedActor[] getRefinement() throws IllegalActionException {
        if (this._refinementVersion == this.workspace().getVersion()) {
            return this._refinement;
        }
        try {
            this.workspace().getReadAccess();
            String names = this.refinementName.getExpression();
            if (names == null || names.trim().equals("")) {
                this._refinementVersion = this.workspace().getVersion();
                this._refinement = null;
                TypedActor[] typedActorArray = null;
                return typedActorArray;
            }
            StringTokenizer tokenizer = new StringTokenizer(names, ",");
            int size = tokenizer.countTokens();
            if (size <= 0) {
                this._refinementVersion = this.workspace().getVersion();
                this._refinement = null;
                TypedActor[] typedActorArray = null;
                return typedActorArray;
            }
            this._refinement = new TypedActor[size];
            NamedObj container = this.getContainer();
            TypedCompositeActor containerContainer = (TypedCompositeActor)container.getContainer();
            int index = 0;
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken().trim();
                if (name.equals("")) {
                    throw new IllegalActionException((Nameable)this, "Malformed list of refinements: " + names);
                }
                if (containerContainer == null) {
                    throw new IllegalActionException((Nameable)this, "Container of \"" + this.getFullName() + "\" is null?  This is not always a problem.");
                }
                TypedActor element = (TypedActor)((Object)containerContainer.getEntity(name));
                if (element == null) {
                    throw new IllegalActionException((Nameable)this, "Cannot find refinement with name \"" + name + "\" in " + containerContainer.getFullName());
                }
                this._refinement[index++] = element;
            }
            this._refinementVersion = this.workspace().getVersion();
            TypedActor[] typedActorArray = this._refinement;
            return typedActorArray;
        }
        finally {
            this.workspace().doneReading();
        }
    }

    public boolean isVisited() {
        return this._visited;
    }

    public List nonpreemptiveTransitionList() {
        if (this._transitionListVersion != this.workspace().getVersion()) {
            this._updateTransitionLists();
        }
        return this._nonpreemptiveTransitionList;
    }

    public List preemptiveTransitionList() {
        if (this._transitionListVersion != this.workspace().getVersion()) {
            this._updateTransitionLists();
        }
        return this._preemptiveTransitionList;
    }

    public void setVisited(boolean visited) {
        this._visited = visited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateTransitionLists() {
        try {
            this.workspace().getReadAccess();
            this._nonpreemptiveTransitionList.clear();
            this._preemptiveTransitionList.clear();
            for (Transition transition : this.outgoingPort.linkedRelationList()) {
                if (transition.isPreemptive()) {
                    this._preemptiveTransitionList.add(transition);
                    continue;
                }
                this._nonpreemptiveTransitionList.add(transition);
            }
            this._transitionListVersion = this.workspace().getVersion();
        }
        finally {
            this.workspace().doneReading();
        }
    }
}

