/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

public final class RelationNode {
    private int _currentType;
    private double _difference;
    private double _previousDifference;
    private int _previousType;

    public RelationNode(int type, double difference) {
        this._currentType = type;
        this._previousType = type;
        this._difference = difference;
        this._previousDifference = difference;
    }

    public void reset() {
        this._previousType = 0;
        this._previousDifference = 0.0;
    }

    public void commit() {
        this._previousType = this._currentType;
        this._previousDifference = this._difference;
    }

    public double getDifference() {
        return this._difference;
    }

    public double getPreviousDifference() {
        return this._previousDifference;
    }

    public boolean hasEvent() {
        if (this.typeChanged()) {
            return this._previousType * this._currentType == 20;
        }
        return false;
    }

    public void setType(int type) {
        this._currentType = type;
    }

    public void setDifference(double difference) {
        this._difference = difference;
    }

    public boolean typeChanged() {
        return this._previousType != 0 && this._previousType != this._currentType;
    }
}

