/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

import java.util.LinkedList;
import java.util.ListIterator;
import ptolemy.domains.fsm.kernel.RelationNode;

public class RelationList {
    private int _maximumDifferenceIndex;
    private LinkedList _relationList = new LinkedList();

    public void addRelation(int type, double difference) {
        this._relationList.add(new RelationNode(type, difference));
    }

    public void resetRelationList() {
        ListIterator relations = this._relationList.listIterator();
        while (relations.hasNext()) {
            ((RelationNode)relations.next()).reset();
        }
    }

    public void commitRelationValues() {
        ListIterator relations = this._relationList.listIterator();
        while (relations.hasNext()) {
            ((RelationNode)relations.next()).commit();
        }
    }

    public void destroy() {
        this._relationList.clear();
    }

    public double getPreviousMaximumDistance() {
        return ((RelationNode)this._relationList.get(this._maximumDifferenceIndex)).getPreviousDifference();
    }

    public boolean hasEvent() {
        boolean result = false;
        ListIterator relations = this._relationList.listIterator();
        while (relations.hasNext() && !result) {
            result = result || ((RelationNode)relations.next()).hasEvent();
        }
        return result;
    }

    public boolean isEmpty() {
        return this._relationList.size() == 0;
    }

    public int length() {
        return this._relationList.size();
    }

    public double getMaximumDifference() {
        double maxDifference = 0.0;
        double difference = 0.0;
        int index = 0;
        this._maximumDifferenceIndex = 0;
        ListIterator relations = this._relationList.listIterator();
        while (relations.hasNext()) {
            RelationNode relation = (RelationNode)relations.next();
            difference = Math.abs(relation.getDifference());
            if (relation.typeChanged() && difference > maxDifference) {
                maxDifference = difference;
                this._maximumDifferenceIndex = index;
            }
            ++index;
        }
        return maxDifference;
    }

    public void setRelation(int relationIndex, int type, double difference) {
        RelationNode relationNode = (RelationNode)this._relationList.get(relationIndex);
        relationNode.setType(type);
        relationNode.setDifference(difference);
    }
}

