/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.fsm.kernel;

import java.util.Iterator;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoRoomException;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.UnknownResultException;
import ptolemy.data.expr.Variable;
import ptolemy.domains.fsm.kernel.AbstractActionsAttribute;
import ptolemy.domains.fsm.kernel.CommitAction;
import ptolemy.domains.fsm.kernel.FSMActor;
import ptolemy.domains.fsm.kernel.Transition;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class CommitActionsAttribute
extends AbstractActionsAttribute
implements CommitAction {
    public CommitActionsAttribute(Workspace workspace) {
        super(workspace);
    }

    public CommitActionsAttribute(Transition transition, String name) throws IllegalActionException, NameDuplicationException {
        super(transition, name);
    }

    @Override
    public void execute() throws IllegalActionException {
        super.execute();
        if (this._destinations != null) {
            Iterator destinations = this._destinations.iterator();
            Iterator channels = this._numbers.iterator();
            Iterator parseTrees = this._parseTrees.iterator();
            while (destinations.hasNext()) {
                NamedObj destination;
                Token token;
                NamedObj nextDestination = (NamedObj)destinations.next();
                Integer channel = (Integer)channels.next();
                ASTPtRootNode parseTree = (ASTPtRootNode)parseTrees.next();
                if (this._scope == null) {
                    FSMActor fsmActor = (FSMActor)this.getContainer().getContainer();
                    this._scope = fsmActor.getPortScope();
                }
                try {
                    token = this._parseTreeEvaluator.evaluateParseTree(parseTree, this._scope);
                }
                catch (IllegalActionException ex) {
                    throw new IllegalActionException((Nameable)this, ex, "Expression invalid.");
                }
                if (nextDestination instanceof IOPort) {
                    destination = (IOPort)nextDestination;
                    try {
                        if (channel != null) {
                            if (token == null) {
                                ((IOPort)destination).sendClear(channel);
                                if (!this._debugging) continue;
                                this._debug(this.getFullName() + " port: " + destination.getName() + " channel: " + channel + ", Clear!");
                                continue;
                            }
                            ((IOPort)destination).send(channel, token);
                            if (!this._debugging) continue;
                            this._debug(this.getFullName() + " port: " + destination.getName() + " channel: " + channel + ", token: " + token);
                            continue;
                        }
                        if (token == null) {
                            ((IOPort)destination).broadcastClear();
                            if (!this._debugging) continue;
                            this._debug(this.getFullName() + " port: " + destination.getName() + " broadcast Clear!");
                            continue;
                        }
                        ((IOPort)destination).broadcast(token);
                        if (!this._debugging) continue;
                        this._debug(this.getFullName() + " port: " + destination.getName() + " broadcast token: " + token);
                        continue;
                    }
                    catch (NoRoomException ex) {
                        throw new IllegalActionException((Nameable)this, "Cannot complete action: " + ex.getMessage());
                    }
                    catch (UnknownResultException ex) {
                        continue;
                    }
                }
                if (nextDestination instanceof Variable) {
                    destination = (Variable)nextDestination;
                    try {
                        ((Variable)destination).setToken(token);
                        ((Variable)destination).validate();
                        if (!this._debugging) continue;
                        this._debug(this.getFullName() + " variable: " + destination.getName() + ", value: " + token);
                    }
                    catch (UnknownResultException ex) {
                        ((Variable)destination).setUnknown(true);
                    }
                    continue;
                }
                throw new IllegalActionException((Nameable)this, "Destination is neither an IOPort nor a Variable: " + nextDestination.getFullName());
            }
        }
    }

    @Override
    protected NamedObj _getDestination(String name) throws IllegalActionException {
        Transition transition = (Transition)this.getContainer();
        if (transition == null) {
            throw new IllegalActionException((Nameable)this, "Action has no container transition.");
        }
        Entity fsm = (Entity)transition.getContainer();
        if (fsm == null) {
            throw new IllegalActionException((Nameable)this, transition, "Transition has no container.");
        }
        IOPort port = (IOPort)fsm.getPort(name);
        if (port == null) {
            Attribute variable = fsm.getAttribute(name);
            if (variable == null) {
                int period = name.indexOf(".");
                if (period > 0) {
                    Attribute entry;
                    ComponentEntity refinement;
                    String refinementName = name.substring(0, period);
                    String entryName = name.substring(period + 1);
                    NamedObj fsmContainer = fsm.getContainer();
                    if (fsmContainer instanceof CompositeEntity && (refinement = ((CompositeEntity)fsmContainer).getEntity(refinementName)) != null && (entry = refinement.getAttribute(entryName)) instanceof Variable) {
                        return entry;
                    }
                }
                throw new IllegalActionException((Nameable)fsm, this, "Cannot find port or variable with the name: " + name);
            }
            if (!(variable instanceof Variable)) {
                throw new IllegalActionException((Nameable)fsm, this, "The attribute with name \"" + name + "\" is not an " + "instance of Variable.");
            }
            return variable;
        }
        if (!port.isOutput()) {
            throw new IllegalActionException((Nameable)fsm, this, "The port is not an output port: " + name);
        }
        return port;
    }
}

