/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.lib;

import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.type.BaseType;
import ptolemy.domains.de.lib.DETransformer;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class TimeGap
extends DETransformer {
    private Time _previousTime;

    public TimeGap(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeEquals(BaseType.DOUBLE);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            this.input.get(0);
        }
        Time currentTime = this.getDirector().getModelTime();
        if (this._previousTime.compareTo(Time.NEGATIVE_INFINITY) != 0) {
            DoubleToken outToken = new DoubleToken(currentTime.subtract(this._previousTime).getDoubleValue());
            this.output.send(0, outToken);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        this._previousTime = Time.NEGATIVE_INFINITY;
        super.initialize();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._previousTime = this.getDirector().getModelTime();
        return super.postfire();
    }
}

