/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.de.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Transformer;
import ptolemy.actor.util.FIFOQueue;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class Queue
extends Transformer {
    public Parameter capacity;
    public Parameter persistentTrigger;
    public TypedIOPort size;
    public TypedIOPort trigger;
    protected FIFOQueue _queue;
    private boolean _persistentTrigger;
    private boolean _removeToken;
    private Token _token;

    public Queue(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeAtLeast(this.input);
        this.trigger = new TypedIOPort(this, "trigger", true, false);
        this.trigger.setMultiport(true);
        StringAttribute cardinality = new StringAttribute(this.trigger, "_cardinal");
        cardinality.setExpression("SOUTH");
        this.size = new TypedIOPort(this, "size", false, true);
        this.size.setTypeEquals(BaseType.INT);
        cardinality = new StringAttribute(this.size, "_cardinal");
        cardinality.setExpression("SOUTH");
        this._queue = new FIFOQueue();
        this.capacity = new Parameter(this, "capacity");
        this.capacity.setTypeEquals(BaseType.INT);
        this.capacity.setExpression("0");
        this.persistentTrigger = new Parameter(this, "persistentTrigger");
        this.persistentTrigger.setTypeEquals(BaseType.BOOLEAN);
        this.persistentTrigger.setExpression("false");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.capacity) {
            int newCapacity = ((IntToken)this.capacity.getToken()).intValue();
            if (newCapacity <= 0) {
                if (this._queue.getCapacity() != -1) {
                    this._queue.setCapacity(-1);
                }
            } else {
                if (newCapacity < this._queue.size()) {
                    throw new IllegalActionException((Nameable)this, "Queue size (" + this._queue.size() + ") exceed requested capacity " + newCapacity + ").");
                }
                this._queue.setCapacity(newCapacity);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        Queue newObject = (Queue)super.clone(workspace);
        newObject._queue = new FIFOQueue();
        newObject.output.setTypeAtLeast(newObject.input);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int sizeOutput = this._queue.size();
        boolean gotTrigger = false;
        for (int i = 0; i < this.trigger.getWidth(); ++i) {
            if (!this.trigger.hasToken(i)) continue;
            this.trigger.get(i);
            gotTrigger = true;
        }
        if (this.input.hasToken(0)) {
            this._token = this.input.get(0);
            if (this._queue.getCapacity() == -1 || this._queue.getCapacity() > this._queue.size() || gotTrigger) {
                ++sizeOutput;
            }
        } else {
            this._token = null;
        }
        if (gotTrigger) {
            if (sizeOutput > 0) {
                if (this._queue.size() == 0) {
                    this.output.send(0, this._token);
                    this._token = null;
                } else {
                    this.output.send(0, (Token)this._queue.get(0));
                    this._removeToken = true;
                }
                --sizeOutput;
                this._persistentTrigger = false;
            } else if (((BooleanToken)this.persistentTrigger.getToken()).booleanValue()) {
                this._persistentTrigger = true;
            }
        } else if (this._persistentTrigger && this._token != null) {
            this.output.send(0, this._token);
            --sizeOutput;
            this._token = null;
            this._persistentTrigger = false;
        }
        this.size.send(0, new IntToken(sizeOutput));
    }

    @Override
    public void initialize() throws IllegalActionException {
        this._queue.clear();
        this._persistentTrigger = false;
        this._token = null;
        this._removeToken = false;
        super.initialize();
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._token != null) {
            this._queue.put(this._token);
        }
        if (this._removeToken) {
            this._queue.take();
        }
        this._token = null;
        this._removeToken = false;
        return super.postfire();
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        boolean hasInput = false;
        boolean hasTrigger = false;
        if (this.input.getWidth() > 0) {
            hasInput = this.input.hasToken(0);
        }
        if (this.trigger.getWidth() > 0) {
            hasTrigger = this.trigger.hasToken(0);
        }
        return hasInput || hasTrigger;
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.input, this.output);
    }

    @Override
    public void wrapup() throws IllegalActionException {
        this._queue.clear();
        super.wrapup();
    }
}

