/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.CTEventGenerator;
import ptolemy.domains.ct.kernel.CTExecutionPhase;
import ptolemy.domains.ct.kernel.CTStepSizeControlActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class LevelCrossingDetector
extends TypedAtomicActor
implements CTStepSizeControlActor,
CTEventGenerator {
    public Parameter defaultEventValue;
    public StringParameter direction;
    public Parameter errorTolerance;
    public Parameter level;
    public TypedIOPort output = new TypedIOPort(this, "output", false, true);
    public TypedIOPort trigger;
    public Parameter useDefaultEventValue;
    protected double _level;
    private boolean _detectRisingCrossing;
    private boolean _detectFallingCrossing;
    private double _errorTolerance;
    private boolean _eventMissed = false;
    private boolean _eventNow = false;
    private double _lastTrigger;
    private double _thisTrigger;

    public LevelCrossingDetector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        new Parameter((NamedObj)this.output, "signalType", new StringToken("DISCRETE"));
        this.trigger = new TypedIOPort(this, "trigger", true, false);
        this.trigger.setMultiport(false);
        this.trigger.setTypeEquals(BaseType.DOUBLE);
        new Parameter((NamedObj)this.trigger, "signalType", new StringToken("CONTINUOUS"));
        this.level = new Parameter((NamedObj)this, "level", new DoubleToken(0.0));
        this.level.setTypeEquals(BaseType.DOUBLE);
        this.direction = new StringParameter(this, "direction");
        this.direction.setExpression("both");
        this._detectRisingCrossing = true;
        this._detectFallingCrossing = true;
        this.direction.addChoice("both");
        this.direction.addChoice("falling");
        this.direction.addChoice("rising");
        this.defaultEventValue = new Parameter((NamedObj)this, "defaultEventValue", new DoubleToken(0.0));
        this.output.setTypeAtLeast(this.defaultEventValue);
        this.useDefaultEventValue = new Parameter(this, "useDefaultEventValue");
        this.useDefaultEventValue.setTypeEquals(BaseType.BOOLEAN);
        this.useDefaultEventValue.setToken(BooleanToken.FALSE);
        this._errorTolerance = 1.0E-4;
        this.errorTolerance = new Parameter((NamedObj)this, "errorTolerance", new DoubleToken(this._errorTolerance));
        this.errorTolerance.setTypeEquals(BaseType.DOUBLE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.errorTolerance) {
            double tolerance = ((DoubleToken)this.errorTolerance.getToken()).doubleValue();
            if (tolerance <= 0.0) {
                throw new IllegalActionException((Nameable)this, "Error tolerance must be greater than 0.");
            }
            this._errorTolerance = tolerance;
            return;
        } else if (attribute == this.direction) {
            String crossingDirections = this.direction.stringValue();
            if (crossingDirections.equalsIgnoreCase("falling")) {
                this._detectFallingCrossing = true;
                this._detectRisingCrossing = false;
                return;
            } else if (crossingDirections.equalsIgnoreCase("rising")) {
                this._detectFallingCrossing = false;
                this._detectRisingCrossing = true;
                return;
            } else {
                if (!crossingDirections.equalsIgnoreCase("both")) throw new IllegalActionException("Unknown direction: " + crossingDirections);
                this._detectFallingCrossing = true;
                this._detectRisingCrossing = true;
            }
            return;
        } else if (attribute == this.level) {
            this._level = ((DoubleToken)this.level.getToken()).doubleValue();
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        LevelCrossingDetector newObject = (LevelCrossingDetector)super.clone(workspace);
        newObject.output.setTypeAtLeast(newObject.defaultEventValue);
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        CTDirector director;
        super.fire();
        this._thisTrigger = ((DoubleToken)this.trigger.get(0)).doubleValue();
        if (this._debugging) {
            this._debug("Consuming a trigger token: " + this._thisTrigger);
        }
        if ((director = (CTDirector)this.getDirector()).getExecutionPhase() == CTExecutionPhase.GENERATING_EVENTS_PHASE) {
            if (this._debugging && this._verbose) {
                this._debug("This is a discrete phase execution.");
            }
            boolean hasEvent = this._eventNow;
            if ((this._lastTrigger - this._level) * (this._thisTrigger - this._level) < 0.0) {
                boolean inputIsIncreasing;
                boolean bl = inputIsIncreasing = this._thisTrigger > this._lastTrigger;
                if (this._detectFallingCrossing && !inputIsIncreasing || this._detectRisingCrossing && inputIsIncreasing) {
                    hasEvent = true;
                }
            }
            if (hasEvent) {
                if (((BooleanToken)this.useDefaultEventValue.getToken()).booleanValue()) {
                    this.output.send(0, this.defaultEventValue.getToken());
                    if (this._debugging) {
                        this._debug("Emitting an event with a default value: " + this.defaultEventValue.getToken());
                    }
                } else {
                    this.output.send(0, new DoubleToken(this._level));
                    if (this._debugging) {
                        this._debug("Emitting an event with the level value: " + this._level);
                    }
                }
                this._eventNow = false;
                this._eventMissed = false;
            }
        }
    }

    @Override
    public boolean hasCurrentEvent() {
        return this._eventNow;
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._eventMissed = false;
        this._eventNow = false;
        this._level = ((DoubleToken)this.level.getToken()).doubleValue();
        this._lastTrigger = 0.0;
        this._thisTrigger = 0.0;
    }

    @Override
    public boolean isOutputAccurate() {
        boolean inputIsIncreasing;
        if (this._debugging && this._verbose) {
            this._debug("The last trigger is " + this._lastTrigger);
            this._debug("The current trigger is " + this._thisTrigger);
        }
        boolean bl = inputIsIncreasing = this._thisTrigger > this._lastTrigger;
        if ((this._lastTrigger - this._level) * (this._thisTrigger - this._level) < 0.0) {
            if (Math.abs(this._thisTrigger - this._level) < this._errorTolerance) {
                if (this._detectFallingCrossing && !inputIsIncreasing || this._detectRisingCrossing && inputIsIncreasing) {
                    if (this._debugging) {
                        this._debug("Event is detected at " + this.getDirector().getModelTime());
                    }
                    this._eventNow = true;
                    this._eventMissed = false;
                } else {
                    this._eventNow = false;
                    this._eventMissed = false;
                }
            } else if (this._detectFallingCrossing && !inputIsIncreasing || this._detectRisingCrossing && inputIsIncreasing) {
                this._eventNow = false;
                this._eventMissed = true;
            } else {
                this._eventNow = false;
                this._eventMissed = false;
            }
        } else if (this._thisTrigger == this._level) {
            if (this._detectFallingCrossing && !inputIsIncreasing || this._detectRisingCrossing && inputIsIncreasing) {
                if (this._debugging) {
                    this._debug("Event is detected at " + this.getDirector().getModelTime());
                }
                this._eventNow = true;
                this._eventMissed = false;
            } else {
                this._eventNow = false;
                this._eventMissed = false;
            }
        } else {
            this._eventNow = false;
            this._eventMissed = false;
        }
        return !this._eventMissed;
    }

    @Override
    public boolean isStateAccurate() {
        return true;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._lastTrigger = this._thisTrigger;
        return super.postfire();
    }

    @Override
    public double predictedStepSize() {
        return Double.MAX_VALUE;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        if (!(this.getDirector() instanceof CTDirector)) {
            throw new IllegalActionException("LevelCrossingDetector can only be used inside CT domain.");
        }
        super.preinitialize();
    }

    @Override
    public double refinedStepSize() {
        CTDirector dir = (CTDirector)this.getDirector();
        double refinedStep = dir.getCurrentStepSize();
        if (this._eventMissed) {
            refinedStep = (Math.abs(this._lastTrigger - this._level) + this._errorTolerance / 2.0) * dir.getCurrentStepSize() / Math.abs(this._thisTrigger - this._lastTrigger);
            if (this._debugging) {
                this._debug(this.getFullName() + " Event Missed: refined step to " + refinedStep + " at " + dir.getModelTime());
            }
        }
        return refinedStep;
    }
}

