/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import java.util.Iterator;
import ptolemy.actor.Actor;
import ptolemy.actor.Director;
import ptolemy.actor.IORelation;
import ptolemy.actor.Manager;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.TypedIORelation;
import ptolemy.actor.lib.Expression;
import ptolemy.data.ArrayToken;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.ct.lib.Integrator;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class DifferentialSystem
extends TypedCompositeActor {
    public Parameter stateVariableNames;
    public Parameter initialStates;
    private boolean _opaque;

    public DifferentialSystem(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        Token[] empty = new StringToken[1];
        this.stateVariableNames = new Parameter(this, "stateVariableNames");
        empty[0] = new StringToken("");
        this.stateVariableNames.setToken(new ArrayToken(BaseType.STRING, empty));
        this.initialStates = new Parameter(this, "initialStates");
        this.initialStates.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.setClassName("ptolemy.domains.ct.lib.DifferentialSystem");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-50\" y=\"-30\" width=\"100\" height=\"60\" style=\"fill:white\"/>\n<text x=\"-45\" y=\"-10\" style=\"font-size:14\">\ndx/dt=f(x, u, t)</text>\n<text x=\"-45\" y=\"10\" style=\"font-size:14\">\n     y=g(x, u, t)</text>\nstyle=\"fill:blue\"/>\n</svg>\n");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.initialStates) {
            DoubleMatrixToken token = (DoubleMatrixToken)this.initialStates.getToken();
            if (token == null) {
                return;
            }
            if (token.getRowCount() != 1 || token.getColumnCount() < 1) {
                throw new IllegalActionException((Nameable)this, "The initialStates must be a row vector.");
            }
            if (this.getManager() != null && this.getManager().getState() == Manager.IDLE) {
                this._requestInitialization();
            }
        } else if (attribute instanceof Parameter) {
            super.attributeChanged(attribute);
            this._requestInitialization();
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Director getDirector() {
        if (this._opaque) {
            return null;
        }
        return this.getExecutiveDirector();
    }

    @Override
    public boolean isOpaque() {
        return this._opaque;
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        this._checkParameters();
        ArrayToken stateNames = (ArrayToken)this.stateVariableNames.getToken();
        int n = stateNames.length();
        int m = this.inputPortList().size();
        int r = this.outputPortList().size();
        try {
            TypedIOPort port;
            int k;
            this._workspace.getWriteAccess();
            this.removeAllEntities();
            this.removeAllRelations();
            Integrator[] integrators = new Integrator[n];
            String[] states = new String[n];
            IORelation[] stateRelations = new IORelation[n];
            Expression[] equations = new Expression[n];
            for (int i = 0; i < n; ++i) {
                states[i] = ((StringToken)stateNames.getElement(i)).stringValue().trim();
                integrators[i] = new Integrator(this, states[i]);
                integrators[i].initialState.setExpression("initialStates(0," + i + ")");
                stateRelations[i] = new TypedIORelation(this, "relation_" + states[i]);
                integrators[i].output.link(stateRelations[i]);
                equations[i] = new Expression(this, states[i] + "_dot");
                equations[i].expression.setExpression(((StringToken)((Parameter)this.getAttribute(states[i] + "_dot")).getToken()).stringValue());
                equations[i].output.setTypeEquals(BaseType.DOUBLE);
                this.connect(equations[i].output, integrators[i].input);
            }
            String[] inputs = new String[m];
            IORelation[] inputRelations = new IORelation[m];
            Iterator inputPorts = this.inputPortList().iterator();
            int inputIndex = 0;
            while (inputPorts.hasNext()) {
                inputs[inputIndex] = ((NamedObj)inputPorts.next()).getName();
                inputRelations[inputIndex] = new TypedIORelation(this, "relation_" + inputs[inputIndex]);
                this.getPort(inputs[inputIndex]).link(inputRelations[inputIndex]);
                ++inputIndex;
            }
            String[] outputs = new String[r];
            Expression[] maps = new Expression[r];
            int outIndex = 0;
            Iterator outputPorts = this.outputPortList().iterator();
            while (outputPorts.hasNext()) {
                outputs[outIndex] = ((NamedObj)outputPorts.next()).getName();
                maps[outIndex] = new Expression(this, "output_" + outputs[outIndex]);
                maps[outIndex].expression.setExpression(((StringToken)((Parameter)this.getAttribute(outputs[outIndex])).getToken()).stringValue());
                maps[outIndex].output.setTypeEquals(BaseType.DOUBLE);
                this.connect(maps[outIndex].output, (TypedIOPort)this.getPort(outputs[outIndex]));
                ++outIndex;
            }
            for (int i = 0; i < n; ++i) {
                for (k = 0; k < n; ++k) {
                    port = new TypedIOPort(equations[i], states[k], true, false);
                    port.setTypeEquals(BaseType.DOUBLE);
                    port.link(stateRelations[k]);
                }
                for (k = 0; k < m; ++k) {
                    port = new TypedIOPort(equations[i], inputs[k], true, false);
                    port.setTypeEquals(BaseType.DOUBLE);
                    port.link(inputRelations[k]);
                }
            }
            for (int l = 0; l < r; ++l) {
                for (k = 0; k < n; ++k) {
                    port = new TypedIOPort(maps[l], states[k], true, false);
                    port.setTypeEquals(BaseType.DOUBLE);
                    port.link(stateRelations[k]);
                }
            }
            this._opaque = false;
            this._workspace.incrVersion();
        }
        catch (NameDuplicationException ex) {
            throw new InternalErrorException("Duplicated name when constructing the subsystem" + ex.getMessage());
        }
        finally {
            this._workspace.doneWriting();
        }
        for (Actor actor : this.deepEntityList()) {
            actor.preinitialize();
        }
    }

    @Override
    public void wrapup() throws IllegalActionException {
        this._opaque = true;
        super.wrapup();
    }

    private void _checkParameters() throws IllegalActionException {
        ArrayToken stateNames = (ArrayToken)this.stateVariableNames.getToken();
        int n = stateNames.length();
        if (n < 1) {
            throw new IllegalActionException((Nameable)this, "There must be at least one state variable for a differential system.");
        }
        for (int i = 0; i < n; ++i) {
            String name = ((StringToken)stateNames.getElement(i)).stringValue().trim();
            if (name.equals("")) {
                throw new IllegalActionException((Nameable)this, "A state variable name should not be an empty string.");
            }
            String equation = name + "_dot";
            if (this.getAttribute(equation) != null) continue;
            throw new IllegalActionException((Nameable)this, "Please add a parameter with name \"" + equation + "\" to specify the state equation.");
        }
        for (TypedIOPort output : this.outputPortList()) {
            String name = output.getName().trim();
            if (name.equals("")) {
                throw new IllegalActionException((Nameable)this, "A output variable name should not be an empty string.");
            }
            if (this.getAttribute(name) != null) continue;
            throw new IllegalActionException((Nameable)this, "Please add a parameter with name \"" + name + "\" to specify the output map.");
        }
    }

    private void _requestInitialization() {
        this._opaque = true;
        Director dir = this.getDirector();
        if (dir != null) {
            dir.requestInitialization(this);
        }
    }
}

