/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.lib;

import ptolemy.actor.Actor;
import ptolemy.actor.lib.Transformer;
import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.CTEventGenerator;
import ptolemy.domains.ct.kernel.CTExecutionPhase;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class CTPeriodicSampler
extends Transformer
implements CTEventGenerator {
    public Parameter samplePeriod;
    private boolean _hasCurrentEvent = false;
    private Time _nextSamplingTime;
    private double _samplePeriod;

    public CTPeriodicSampler(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(true);
        new Parameter((NamedObj)this.input, "signalType", new StringToken("CONTINUOUS"));
        this.output.setMultiport(true);
        new Parameter((NamedObj)this.output, "signalType", new StringToken("DISCRETE"));
        this._samplePeriod = 0.1;
        this.samplePeriod = new Parameter((NamedObj)this, "samplePeriod", new DoubleToken(this._samplePeriod));
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-30\" y=\"-20\" width=\"60\" height=\"40\" style=\"fill:white\"/>\n<polyline points=\"-30,0 -20,0 -10,0 10,-7\"/>\n<polyline points=\"10,0 30,0\"/>\n</svg>\n");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.samplePeriod) {
            double p = ((DoubleToken)this.samplePeriod.getToken()).doubleValue();
            if (p <= 0.0) {
                throw new IllegalActionException((Nameable)this, " Sample period must be greater than 0.");
            }
            this._samplePeriod = p;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        CTDirector director = (CTDirector)this.getDirector();
        if (director.getExecutionPhase() == CTExecutionPhase.GENERATING_EVENTS_PHASE && this.hasCurrentEvent()) {
            for (int i = 0; i < Math.min(this.input.getWidth(), this.output.getWidth()); ++i) {
                if (!this.input.hasToken(i)) continue;
                Token token = this.input.get(i);
                this.output.send(i, token);
                if (!this._debugging) continue;
                this._debug(this.getFullName(), " sends event: " + token + " to channel " + i + ", at: " + this.getDirector().getModelTime());
            }
        }
    }

    @Override
    public boolean hasCurrentEvent() {
        CTDirector director = (CTDirector)this.getDirector();
        if (director.getModelTime().compareTo(this._nextSamplingTime) == 0) {
            this._hasCurrentEvent = true;
            if (this._debugging && this._verbose) {
                this._debug(this.getFullName(), " has an event at: " + director.getModelTime() + ".");
            }
        } else {
            this._hasCurrentEvent = false;
        }
        return this._hasCurrentEvent;
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        CTDirector dir = (CTDirector)this.getDirector();
        this._nextSamplingTime = dir.getModelTime();
        if (this._debugging) {
            this._debug("Next sampling time is at " + this._nextSamplingTime);
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        CTDirector director = (CTDirector)this.getDirector();
        if (director.getExecutionPhase() == CTExecutionPhase.GENERATING_EVENTS_PHASE && this.hasCurrentEvent()) {
            this._nextSamplingTime = this._nextSamplingTime.add(this._samplePeriod);
            if (this._debugging) {
                this._debug("Request refiring at " + this._nextSamplingTime);
            }
            this.getDirector().fireAt((Actor)this, this._nextSamplingTime);
        }
        return true;
    }
}

