/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel;

import java.util.Iterator;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.util.Time;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.ct.kernel.CTMultiSolverDirector;
import ptolemy.domains.ct.kernel.CTSchedule;
import ptolemy.domains.ct.kernel.CTStatefulActor;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class CTMixedSignalDirector
extends CTMultiSolverDirector {
    public Parameter runAheadLength;
    private boolean _isTop;
    private Time _knownGoodTime;
    private long _mutationVersion = -1L;
    private Time _outsideTime;
    private double _runAheadLength;

    public CTMixedSignalDirector() {
    }

    public CTMixedSignalDirector(Workspace workspace) {
        super(workspace);
    }

    public CTMixedSignalDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.runAheadLength) {
            double value;
            if (this._debugging) {
                this._debug("run ahead length updating.");
            }
            if ((value = ((DoubleToken)this.runAheadLength.getToken()).doubleValue()) < 0.0) {
                throw new IllegalActionException((Nameable)this, " runAheadLength cannot be negative.");
            }
            this._runAheadLength = value;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public boolean canBeInsideDirector() {
        return true;
    }

    @Override
    public void fire() throws IllegalActionException {
        this._knownGoodTime = this.getModelTime();
        super.fire();
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._mutationVersion = -1L;
        if (!this._isTopLevel()) {
            TypedCompositeActor container = (TypedCompositeActor)this.getContainer();
            Director exe = container.getExecutiveDirector();
            exe.fireAt((Actor)container, this.getModelTime());
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (!this._isTopLevel()) {
            this.fireAt((Actor)((CompositeActor)this.getContainer()), this.getModelTime());
        }
        return super.postfire();
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (this._debugging) {
            this._debug("\n", this.getName(), " prefire: ");
        }
        if (!this._isTopLevel()) {
            CompositeActor container = (CompositeActor)this.getContainer();
            Director executiveDirector = container.getExecutiveDirector();
            this._outsideTime = executiveDirector.getModelTime();
            Time localTime = this.getModelTime();
            Time outsideNextIterationTime = executiveDirector.getModelNextIterationTime();
            if (this._debugging) {
                this._debug("The current time of outside model is " + this._outsideTime, " and its next iteration time is " + outsideNextIterationTime, "\nThe current time of this director is " + localTime);
            }
            if (outsideNextIterationTime.compareTo(this._outsideTime) < 0) {
                throw new IllegalActionException((Nameable)this, "Outside domain time is going backward. Current outside time = " + this._outsideTime + ", but the next iteration time = " + outsideNextIterationTime);
            }
            double aheadLength = this._runAheadLength;
            if (this._outsideTime.compareTo(localTime) > 0) {
                throw new IllegalActionException((Nameable)this, executiveDirector, "Outside time is later than the local time. This should never happen.");
            }
            if (this._outsideTime.compareTo(localTime) < 0) {
                if (this._debugging) {
                    this._debug(this.getName() + " rollback from: " + localTime + " to: " + this._knownGoodTime + "due to outside time " + this._outsideTime);
                }
                this._rollback();
                aheadLength = this._outsideTime.subtract(this.getModelTime()).getDoubleValue();
            } else {
                aheadLength = outsideNextIterationTime.subtract(this._outsideTime).getDoubleValue();
            }
            if (this._debugging) {
                this._debug(this.getName(), " local time = " + localTime, " Outside Time = " + this._outsideTime, " NextIterationTime = " + outsideNextIterationTime + " Inferred run length = " + aheadLength);
            }
            if (aheadLength < this.getTimeResolution()) {
                if (this._debugging) {
                    this._debug("This is an iteration with the step size as 0.");
                }
                aheadLength = 0.0;
            } else if (aheadLength > this._runAheadLength) {
                aheadLength = this._runAheadLength;
            }
            double currentSuggestedNextStepSize = this.getSuggestedNextStepSize();
            if (aheadLength < currentSuggestedNextStepSize || currentSuggestedNextStepSize == 0.0) {
                this.setSuggestedNextStepSize(aheadLength);
            }
            if (this._debugging) {
                this._debug(this.getName(), "The suggested step size is set to " + this.getSuggestedNextStepSize());
            }
            this._setIterationBeginTime(this.getModelTime());
            return true;
        }
        return super.prefire();
    }

    @Override
    protected void _initParameters() {
        super._initParameters();
        try {
            this._runAheadLength = 0.1;
            this.runAheadLength = new Parameter((NamedObj)this, "runAheadLength", new DoubleToken(this._runAheadLength));
            this.runAheadLength.setTypeEquals(BaseType.DOUBLE);
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException("Parameter creation error.");
        }
        catch (NameDuplicationException ex) {
            throw new InvalidStateException(this, "Parameter name duplication.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean _isTopLevel() {
        long version = this.workspace().getVersion();
        if (version == this._mutationVersion) {
            return this._isTop;
        }
        try {
            this.workspace().getReadAccess();
            CompositeActor container = (CompositeActor)this.getContainer();
            this._isTop = container.getExecutiveDirector() == null;
            this._mutationVersion = version;
        }
        finally {
            this.workspace().doneReading();
        }
        return this._isTop;
    }

    protected void _rollback() throws IllegalActionException {
        this.setModelTime(this._knownGoodTime);
        CTSchedule schedule = (CTSchedule)this.getScheduler().getSchedule();
        Iterator actors = schedule.get(7).actorIterator();
        while (actors.hasNext()) {
            CTStatefulActor actor = (CTStatefulActor)actors.next();
            if (this._debugging) {
                this._debug("Restore State..." + actor.getName());
            }
            actor.goToMarkedState();
        }
    }
}

