/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.domains.ct.kernel;

import java.util.Iterator;
import java.util.LinkedList;
import ptolemy.actor.TimedActor;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.domains.ct.kernel.CTDirector;
import ptolemy.domains.ct.kernel.CTDynamicActor;
import ptolemy.domains.ct.kernel.CTStatefulActor;
import ptolemy.domains.ct.kernel.CTStepSizeControlActor;
import ptolemy.domains.ct.kernel.ODESolver;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.InvalidStateException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class CTBaseIntegrator
extends TypedAtomicActor
implements TimedActor,
CTStepSizeControlActor,
CTDynamicActor,
CTStatefulActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public TypedIOPort output;
    public Parameter initialState;
    protected History _history;
    private double[] _auxVariables;
    private double _derivative;
    private double _state;
    private double _storedState;
    private boolean _successful = false;
    private double _tentativeDerivative;
    private double _tentativeState;

    public CTBaseIntegrator(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.output = new TypedIOPort(this, "output", false, true);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.initialState = new Parameter((NamedObj)this, "initialState", new DoubleToken(0.0));
        this.initialState.setTypeEquals(BaseType.DOUBLE);
        this._history = new History(this);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.initialState) {
            this._storedState = this._state = (this._tentativeState = ((DoubleToken)this.initialState.getToken()).doubleValue());
        } else {
            super.attributeChanged(attribute);
        }
    }

    public void clearHistory() {
        this._history.clear();
    }

    @Override
    public void emitCurrentStates() throws IllegalActionException {
        this.output.send(0, new DoubleToken(this._tentativeState));
    }

    @Override
    public void fire() throws IllegalActionException {
        CTDirector dir = (CTDirector)this.getDirector();
        ODESolver solver = dir.getCurrentODESolver();
        if (this._debugging) {
            this._debug(this.getName() + "fire using solver: ", solver.getName());
        }
        solver.integratorFire(this);
    }

    public double[] getAuxVariables() {
        return this._auxVariables;
    }

    public final double getDerivative() {
        return this._derivative;
    }

    public double[] getHistory(int index) {
        return this._history.getEntry(index);
    }

    public final int getHistoryCapacity() {
        return this._history.getCapacity();
    }

    public final double getState() {
        return this._state;
    }

    public double getTentativeDerivative() {
        return this._tentativeDerivative;
    }

    public double getTentativeState() {
        return this._tentativeState;
    }

    public final int getValidHistoryCount() {
        return this._history.getValidEntryCount();
    }

    @Override
    public void goToMarkedState() {
        if (this._debugging) {
            this._debug(this.getName() + " restoring states to " + this._storedState);
        }
        this._state = this._storedState;
        this.setTentativeState(this._storedState);
    }

    @Override
    public void initialize() throws IllegalActionException {
        CTDirector dir = null;
        try {
            dir = (CTDirector)this.getDirector();
        }
        catch (ClassCastException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Failed to cast \"" + this.getDirector() + "\" to a CTDirector.");
        }
        if (dir == null) {
            throw new IllegalActionException((Nameable)this, " no director available");
        }
        ODESolver solver = dir.getCurrentODESolver();
        if (solver == null) {
            throw new IllegalActionException((Nameable)this, " no ODE solver available");
        }
        super.initialize();
        this._tentativeState = ((DoubleToken)this.initialState.getToken()).doubleValue();
        this._tentativeDerivative = 0.0;
        this._state = this._tentativeState;
        this._derivative = this._tentativeDerivative;
        if (this._debugging) {
            this._debug(this.getName(), " initialize: initial state = " + this._tentativeState + " derivative = " + this._tentativeDerivative);
        }
        this._history.clear();
    }

    @Override
    public boolean isOutputAccurate() {
        return true;
    }

    @Override
    public boolean isStateAccurate() {
        try {
            double f_dot = ((DoubleToken)this.input.get(0)).doubleValue();
            if (Double.isNaN(f_dot) || Double.isInfinite(f_dot)) {
                throw new InternalErrorException("The input of " + this.getName() + " is not valid because" + " it is a result of divide-by-zero.");
            }
        }
        catch (IllegalActionException e) {
            throw new InternalErrorException(this.getName() + " can't read input." + e.getMessage());
        }
        ODESolver solver = ((CTDirector)this.getDirector()).getCurrentODESolver();
        this._successful = solver.integratorIsAccurate(this);
        return this._successful;
    }

    @Override
    public void markState() {
        this._storedState = this.getState();
        if (this._debugging) {
            this._debug(this.getName() + " saving state " + this._storedState);
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._state = this._tentativeState;
        this._derivative = this._tentativeDerivative;
        if (this._debugging) {
            this._debug("Saving the following into history: state: " + this._state + " derivative: " + this._derivative);
        }
        if (this.getHistoryCapacity() > 0) {
            this._history.pushEntry(this._tentativeState, this._tentativeDerivative);
        }
        return true;
    }

    @Override
    public double predictedStepSize() {
        ODESolver solver = ((CTDirector)this.getDirector()).getCurrentODESolver();
        return solver.integratorPredictedStepSize(this);
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        CTDirector dir = (CTDirector)this.getDirector();
        if (dir == null) {
            throw new IllegalActionException((Nameable)this, " does not have a director.");
        }
        ODESolver solver = dir.getCurrentODESolver();
        if (solver == null) {
            throw new IllegalActionException((Nameable)this, " does not have an ODE solver.");
        }
        int n = solver.getIntegratorAuxVariableCount();
        if (this._auxVariables == null || this._auxVariables.length != n) {
            this._auxVariables = new double[n];
        }
        if (this.getHistoryCapacity() != solver.getAmountOfHistoryInformation()) {
            this.setHistoryCapacity(solver.getAmountOfHistoryInformation());
        }
        if (this.getValidHistoryCount() >= 2) {
            this._history.rebalance(dir.getCurrentStepSize());
        }
        return true;
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.input, this.output);
    }

    @Override
    public double refinedStepSize() {
        double step = ((CTDirector)this.getDirector()).getCurrentStepSize();
        if (this._successful) {
            return step;
        }
        return 0.5 * step;
    }

    public void setAuxVariables(int index, double value) throws InvalidStateException {
        try {
            this._auxVariables[index] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidStateException(this, "index out of the range of the auxVariables.");
        }
    }

    public final void setHistoryCapacity(int cap) {
        this._history.setCapacity(cap);
    }

    public final void setTentativeDerivative(double value) {
        this._tentativeDerivative = value;
    }

    public final void setTentativeState(double value) {
        this._tentativeState = value;
    }

    private static class DoubleDouble {
        private double[] _data = new double[2];

        public DoubleDouble(double first, double second) {
            this._data[0] = first;
            this._data[1] = second;
        }

        public double[] toArray() {
            return this._data;
        }
    }

    protected class History {
        CTBaseIntegrator _container;
        LinkedList _entries;
        int _capacity;
        double _stepsize;

        public History(CTBaseIntegrator container) {
            this._container = container;
            this._entries = new LinkedList();
            this._capacity = 0;
            this._stepsize = 0.0;
        }

        public void clear() {
            this._entries.clear();
        }

        public int getCapacity() {
            return this._capacity;
        }

        public int getValidEntryCount() {
            return this._entries.size();
        }

        public double[] getEntry(int index) {
            return ((DoubleDouble)this._entries.get(index)).toArray();
        }

        public void pushEntry(double state, double derivative) throws IllegalActionException {
            DoubleDouble entry;
            if (this._capacity > 0) {
                entry = new DoubleDouble(state, derivative);
                if (this._entries.size() >= this._capacity) {
                    this._entries.removeLast();
                }
            } else {
                throw new IllegalActionException((Nameable)CTBaseIntegrator.this.getContainer(), "The history capacity is less than or equal to 0.");
            }
            this._entries.addFirst(entry);
            this._stepsize = ((CTDirector)this._container.getDirector()).getCurrentStepSize();
        }

        public void rebalance(double currentStepSize) throws IllegalActionException {
            double timeResolution = ((CTDirector)this._container.getDirector()).getTimeResolution();
            if (Math.abs(currentStepSize - this._stepsize) > timeResolution) {
                double[][] history = this.toDoubleArray();
                int size = this._entries.size();
                for (int i = 0; i < size - 1; ++i) {
                    this._entries.removeLast();
                }
                double ratio = currentStepSize / this._stepsize;
                for (int i = 1; i < size; ++i) {
                    double[] newEntry;
                    int bin = (int)Math.floor((double)i * ratio);
                    if (bin < size) {
                        double remainder = (double)i * ratio - (double)bin;
                        newEntry = this._Hermite(history[bin + 1], history[bin], 1.0 - remainder);
                    } else {
                        newEntry = this._extrapolation(history[size - 2], history[size - 1], (double)i * ratio - (double)size + 1.0);
                    }
                    this._entries.addLast(new DoubleDouble(newEntry[0], newEntry[1]));
                }
                this._stepsize = currentStepSize;
            }
        }

        public void setCapacity(int capacity) {
            int n = this._capacity = capacity > 0 ? capacity : 0;
            while (this._entries.size() > capacity) {
                this._entries.removeLast();
            }
        }

        public double[][] toDoubleArray() {
            double[][] array = new double[this._entries.size()][2];
            Iterator objs = this._entries.iterator();
            int i = 0;
            while (objs.hasNext()) {
                DoubleDouble entry = (DoubleDouble)objs.next();
                array[i++] = entry.toArray();
            }
            return array;
        }

        private double[] _Hermite(double[] p1, double[] p2, double s) {
            double s3 = s * s * s;
            double s2 = s * s;
            double h1 = 2.0 * s3 - 3.0 * s2 + 1.0;
            double h2 = -2.0 * s3 + 3.0 * s2;
            double h3 = s3 - 2.0 * s2 + s;
            double h4 = s3 - s2;
            double g1 = 6.0 * s2 - 6.0 * s;
            double g2 = -6.0 * s2 + 6.0 * s;
            double g3 = 3.0 * s2 - 4.0 * s + 1.0;
            double g4 = 3.0 * s2 - 2.0 * s;
            double[] result = new double[]{h1 * p1[0] + h2 * p2[0] + h3 * p1[1] + h4 * p2[1], g1 * p1[0] + g2 * p2[0] + g3 * p1[1] + g4 * p2[1]};
            return result;
        }

        private double[] _extrapolation(double[] p1, double[] p2, double s) {
            double[] result = new double[]{p2[0] - (p1[0] - p2[0]) * s, p2[1] - (p1[1] - p2[1]) * s};
            return result;
        }
    }
}

