/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.unit;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import ptolemy.data.unit.ParseException;
import ptolemy.data.unit.SimpleCharStream;
import ptolemy.data.unit.Token;
import ptolemy.data.unit.UParserConstants;
import ptolemy.data.unit.UParserTokenManager;
import ptolemy.data.unit.Unit;
import ptolemy.data.unit.UnitEquation;
import ptolemy.data.unit.UnitExpr;
import ptolemy.data.unit.UnitLibrary;
import ptolemy.data.unit.UnitTerm;

public class UParser
implements UParserConstants {
    boolean debug = false;
    public UParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private int jj_gen;
    private final int[] jj_la1 = new int[7];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public UParser() {
        this(new StringReader(""));
    }

    public UnitExpr parseUnitExpr(String expression) throws ParseException {
        if (expression.equals("")) {
            return null;
        }
        StringReader reader = new StringReader(expression);
        this.ReInit(reader);
        UnitExpr unitExpr = this.uExpr();
        return unitExpr;
    }

    public Vector parseEquations(String expression) throws ParseException {
        if (expression.equals("")) {
            return null;
        }
        StringReader reader = new StringReader(expression);
        this.ReInit(reader);
        Vector _equations = this.Equations();
        return _equations;
    }

    public final UnitExpr uExpr() throws ParseException {
        UnitExpr unitExpr;
        block9: {
            UnitTerm unitTerm = null;
            UnitTerm firstUnitTerm = null;
            unitExpr = new UnitExpr();
            firstUnitTerm = this.uTerm();
            unitExpr.addUnitTerm(firstUnitTerm);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 7: 
                    case 8: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 19: 
                    case 20: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        unitTerm = this.uTerm();
                        unitExpr.addUnitTerm(unitTerm.invert());
                        continue block8;
                    }
                    case 7: {
                        this.jj_consume_token(7);
                        unitTerm = this.uTerm();
                        unitExpr.addUnitTerm(unitTerm);
                        continue block8;
                    }
                    case 14: 
                    case 16: 
                    case 17: 
                    case 19: 
                    case 20: {
                        unitTerm = this.uTerm();
                        unitExpr.addUnitTerm(unitTerm);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[1] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return unitExpr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final UnitTerm uTerm() throws ParseException {
        UnitTerm unitTerm = new UnitTerm();
        if (this.jj_2_1(2)) {
            Token U = this.unit();
            this.jj_consume_token(9);
            int exponent = this.exponent();
            String unitLabel = U.image;
            if (U.kind == 19) {
                unitTerm.setVariable(unitLabel.substring(1));
            } else {
                if (U.kind != 17) throw new ParseException(unitLabel + " is a not variable and is not a Unit");
                Unit unit = UnitLibrary.getUnitByName(unitLabel);
                if (unit == null) throw new ParseException(unitLabel + " is a not variable and is not grounded in the Units Library");
                unitTerm.setUnit(unit);
            }
            unitTerm.setExponent(exponent);
            return unitTerm;
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: 
                case 19: {
                    Token U = this.unit();
                    String unitLabel = U.image;
                    if (U.kind == 19) {
                        unitTerm.setVariable(unitLabel.substring(1));
                        return unitTerm;
                    }
                    if (U.kind != 17) throw new ParseException(unitLabel + " is a not variable and is not a Unit");
                    Unit unit = UnitLibrary.getUnitByName(unitLabel);
                    if (unit == null) throw new ParseException(unitLabel + " is a not variable and is not grounded in the Units Library");
                    unitTerm.setUnit(unit);
                    return unitTerm;
                }
                case 14: 
                case 16: {
                    double scale = this.number();
                    Unit unit = new Unit();
                    unit.setScale(scale);
                    unitTerm.setUnit(unit);
                    return unitTerm;
                }
                case 20: {
                    this.jj_consume_token(20);
                    UnitExpr unitExpr = this.uExpr();
                    this.jj_consume_token(21);
                    unitTerm.setUnitExpr(unitExpr);
                    return unitTerm;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final Token unit() throws ParseException {
        Token retv;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                retv = this.jj_consume_token(17);
                break;
            }
            case 19: {
                retv = this.jj_consume_token(19);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return retv;
    }

    public final Vector Equations() throws ParseException {
        Vector l = null;
        UnitEquation node = this.Equation();
        while (this.jj_2_2(2)) {
            this.jj_consume_token(13);
            l = this.Equations();
        }
        if (l == null) {
            l = new Vector();
        }
        l.add(node);
        return l;
    }

    public final UnitEquation Equation() throws ParseException {
        UnitExpr lhs = this.uExpr();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                Token r = this.jj_consume_token(10);
                break;
            }
            case 11: {
                Token r = this.jj_consume_token(11);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        UnitExpr rhs = this.uExpr();
        UnitEquation uEquation = new UnitEquation(lhs, rhs);
        return uEquation;
    }

    public final int exponent() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                Token x = this.jj_consume_token(14);
                int retv = Integer.parseInt(x.image);
                return retv;
            }
            case 6: {
                this.jj_consume_token(6);
                Token x = this.jj_consume_token(14);
                int retv = -Integer.parseInt(x.image);
                return retv;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final double number() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                try {
                    Double value;
                    String x = this.token.image.toLowerCase();
                    int len = x.length();
                    if (!x.endsWith("d") && !x.endsWith("f")) {
                        value = new Double(x);
                        return value;
                    }
                    value = new Double(x.substring(0, len - 1));
                    return value;
                }
                catch (NumberFormatException ee) {
                    throw new ParseException("Unable to convert token " + this.token.image + " to an float or double");
                }
            }
            case 14: {
                int prefixLength;
                int radix;
                this.jj_consume_token(14);
                String x = this.token.image.toLowerCase();
                int len = x.length();
                boolean mustBeLong = x.endsWith("l");
                int suffixLength = mustBeLong ? 1 : 0;
                if (x.startsWith("0x")) {
                    radix = 16;
                    prefixLength = 2;
                } else if (x.startsWith("0")) {
                    radix = 8;
                    prefixLength = 0;
                } else {
                    radix = 10;
                    prefixLength = 0;
                }
                x = x.substring(prefixLength, len - suffixLength);
                if (mustBeLong) {
                    return Long.parseLong(x, radix);
                }
                {
                    catch (NumberFormatException ee) {
                        throw new ParseException("Unable to convert token " + this.token.image + " to an integer or long");
                    }
                    try {
                        return Integer.parseInt(x, radix);
                    }
                    catch (NumberFormatException nfe) {}
                    return Double.NaN;
                }
            }
        }
        this.jj_la1[6] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private final boolean jj_3R_9() {
        return this.jj_3R_11();
    }

    private final boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_1()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_8()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_9()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_10()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_13() {
        return this.jj_scan_token(14);
    }

    private final boolean jj_3R_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(17)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(19)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_12() {
        return this.jj_scan_token(16);
    }

    private final boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_13()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_4() {
        return this.jj_3R_5();
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_3R_4();
    }

    private final boolean jj_3R_6() {
        return this.jj_3R_7();
    }

    private final boolean jj_3R_10() {
        return this.jj_scan_token(20);
    }

    private final boolean jj_3R_5() {
        return this.jj_3R_6();
    }

    private final boolean jj_3R_8() {
        return this.jj_3R_3();
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_3()) {
            return true;
        }
        return this.jj_scan_token(9);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{1786240, 1786240, 1785856, 655360, 3072, 16448, 81920};
    }

    public UParser(InputStream stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new UParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public UParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new UParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public UParser(UParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(UParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[22];
        for (i = 0; i < 22; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 7; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 22; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        UParser.jj_la1_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

