/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.type;

import java.io.Serializable;
import ptolemy.data.BooleanMatrixToken;
import ptolemy.data.ComplexMatrixToken;
import ptolemy.data.ComplexToken;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.FixMatrixToken;
import ptolemy.data.FixToken;
import ptolemy.data.IntMatrixToken;
import ptolemy.data.IntToken;
import ptolemy.data.LongMatrixToken;
import ptolemy.data.LongToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.FixType;
import ptolemy.data.type.StructuredType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.math.Complex;
import ptolemy.math.FixPoint;

public class MatrixType
extends StructuredType
implements Serializable {
    private Class _tokenClass;
    private Type _elementType;
    private String _name;

    public MatrixType(Class c, Type type, String name) {
        this._tokenClass = c;
        this._elementType = type;
        this._name = name;
        BaseType._addType(this, name, c);
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public Token convert(Token token) throws IllegalActionException {
        if (token instanceof MatrixToken) {
            return token;
        }
        throw new IllegalActionException(Token.notSupportedIncomparableConversionMessage(token, "matrix"));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MatrixType)) {
            return false;
        }
        MatrixType matrixType = (MatrixType)object;
        return matrixType.getTokenClass() == this._tokenClass;
    }

    public Type getElementType() {
        return this._elementType;
    }

    public static MatrixType getMatrixTypeForElementType(Type elementType) throws IllegalActionException {
        MatrixType matrixType;
        if (((Object)elementType).equals(BaseType.UNKNOWN)) {
            throw new IllegalActionException("Cannot resolve type for matrix construction.");
        }
        if (((Object)elementType).equals(BaseType.BOOLEAN)) {
            matrixType = BaseType.BOOLEAN_MATRIX;
        } else if (((Object)elementType).equals(BaseType.INT)) {
            matrixType = BaseType.INT_MATRIX;
        } else if (((Object)elementType).equals(BaseType.LONG)) {
            matrixType = BaseType.LONG_MATRIX;
        } else if (((Object)elementType).equals(BaseType.DOUBLE)) {
            matrixType = BaseType.DOUBLE_MATRIX;
        } else if (((Object)elementType).equals(BaseType.COMPLEX)) {
            matrixType = BaseType.COMPLEX_MATRIX;
        } else if (elementType instanceof FixType) {
            matrixType = BaseType.FIX_MATRIX;
        } else if (((Object)elementType).equals(BaseType.UNSIZED_FIX)) {
            matrixType = BaseType.FIX_MATRIX;
        } else {
            throw new IllegalActionException("Type " + elementType + " does have a corresponding matrix type.");
        }
        return matrixType;
    }

    @Override
    public Class getTokenClass() {
        return this._tokenClass;
    }

    public int hashCode() {
        return this.getTokenClass().hashCode();
    }

    @Override
    public void initialize(Type type) {
    }

    @Override
    public boolean isAbstract() {
        return this._elementType.isAbstract();
    }

    @Override
    public boolean isCompatible(Type type) {
        int typeInfo = TypeLattice.compare((Type)this, type);
        return typeInfo == 0 || typeInfo == 1;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isInstantiable() {
        return this._elementType.isInstantiable();
    }

    @Override
    public boolean isSubstitutionInstance(Type type) {
        if (type instanceof StructuredType) {
            return ((StructuredType)type)._getRepresentative() == this._getRepresentative();
        }
        return false;
    }

    @Override
    public String toString() {
        return this._name;
    }

    @Override
    public void updateType(StructuredType newType) throws IllegalActionException {
        if (newType._getRepresentative() != this._getRepresentative()) {
            throw new InternalErrorException("MatrixType.updateType: Cannot updateType the element type to " + newType + ".");
        }
    }

    @Override
    protected int _compare(StructuredType type) {
        return 0;
    }

    @Override
    protected StructuredType _getRepresentative() {
        return this;
    }

    @Override
    protected StructuredType _greatestLowerBound(StructuredType type) {
        return this;
    }

    @Override
    protected StructuredType _leastUpperBound(StructuredType type) {
        return this;
    }

    public static class LongMatrixType
    extends MatrixType {
        public LongMatrixType() {
            super(LongMatrixToken.class, BaseType.LONG, "[long]");
        }

        @Override
        public Token convert(Token token) throws IllegalActionException {
            if (token instanceof MatrixToken) {
                return LongMatrixToken.convert(token);
            }
            if (token.isNil()) {
                throw new IllegalActionException(Token.notSupportedConversionMessage(token, this.toString()));
            }
            LongToken singleMember = LongToken.convert(token);
            long[] matrix = new long[]{singleMember.longValue()};
            return new LongMatrixToken(matrix, 1, 1);
        }
    }

    public static class FixMatrixType
    extends MatrixType {
        public FixMatrixType() {
            super(FixMatrixToken.class, BaseType.UNSIZED_FIX, "[fixedpoint]");
        }

        @Override
        public Token convert(Token token) throws IllegalActionException {
            if (token instanceof MatrixToken) {
                return FixMatrixToken.convert(token);
            }
            if (token.isNil()) {
                throw new IllegalActionException(Token.notSupportedConversionMessage(token, this.toString()));
            }
            FixToken singleMember = FixToken.convert(token);
            FixPoint[][] matrix = new FixPoint[1][1];
            matrix[0][0] = singleMember.fixValue();
            return new FixMatrixToken(matrix);
        }
    }

    public static class IntMatrixType
    extends MatrixType {
        public IntMatrixType() {
            super(IntMatrixToken.class, BaseType.INT, "[int]");
        }

        @Override
        public Token convert(Token token) throws IllegalActionException {
            if (token instanceof MatrixToken) {
                return IntMatrixToken.convert(token);
            }
            if (token.isNil()) {
                throw new IllegalActionException(Token.notSupportedConversionMessage(token, this.toString()));
            }
            IntToken singleMember = IntToken.convert(token);
            int[] matrix = new int[]{singleMember.intValue()};
            return new IntMatrixToken(matrix, 1, 1);
        }
    }

    public static class DoubleMatrixType
    extends MatrixType {
        public DoubleMatrixType() {
            super(DoubleMatrixToken.class, BaseType.DOUBLE, "[double]");
        }

        @Override
        public Token convert(Token token) throws IllegalActionException {
            if (token instanceof MatrixToken) {
                return DoubleMatrixToken.convert(token);
            }
            if (token.isNil()) {
                throw new IllegalActionException(Token.notSupportedConversionMessage(token, this.toString()));
            }
            DoubleToken singleMember = DoubleToken.convert(token);
            double[] matrix = new double[]{singleMember.doubleValue()};
            return new DoubleMatrixToken(matrix, 1, 1);
        }
    }

    public static class ComplexMatrixType
    extends MatrixType {
        public ComplexMatrixType() {
            super(ComplexMatrixToken.class, BaseType.COMPLEX, "[complex]");
        }

        @Override
        public Token convert(Token token) throws IllegalActionException {
            if (token instanceof MatrixToken) {
                return ComplexMatrixToken.convert(token);
            }
            if (token.isNil()) {
                throw new IllegalActionException(Token.notSupportedConversionMessage(token, this.toString()));
            }
            ComplexToken singleMember = ComplexToken.convert(token);
            Complex[][] matrix = new Complex[1][1];
            matrix[0][0] = singleMember.complexValue();
            return new ComplexMatrixToken(matrix);
        }
    }

    public static class BooleanMatrixType
    extends MatrixType {
        public BooleanMatrixType() {
            super(BooleanMatrixToken.class, BaseType.BOOLEAN, "[boolean]");
        }

        @Override
        public Token convert(Token token) throws IllegalActionException {
            if (token instanceof MatrixToken) {
                return BooleanMatrixToken.convert(token);
            }
            throw new IllegalActionException(Token.notSupportedConversionMessage(token, this.toString()));
        }
    }
}

