/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data.expr;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ptolemy.data.expr.ParserScope;
import ptolemy.data.expr.ScopeExtender;
import ptolemy.data.expr.Variable;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.NamedObj;

public abstract class ModelScope
implements ParserScope {
    public static Set getAllScopedVariableNames(Variable exclude, NamedObj container) {
        List variableList = container.attributeList(Variable.class);
        variableList.remove(exclude);
        HashSet<String> nameSet = new HashSet<String>();
        for (Variable variable : variableList) {
            nameSet.add(variable.getName());
        }
        NamedObj aboveContainer = container.getContainer();
        if (aboveContainer != null) {
            nameSet.addAll(ModelScope.getAllScopedVariableNames(exclude, aboveContainer));
        }
        for (ScopeExtender extender : container.attributeList(ScopeExtender.class)) {
            nameSet.addAll(ModelScope.getAllScopedVariableNames(exclude, (NamedObj)((Object)extender)));
        }
        return nameSet;
    }

    public static Variable getScopedVariable(Variable exclude, NamedObj container, String name) {
        String insideName = name.replaceAll("::", ".");
        while (container != null) {
            Variable result = ModelScope._searchIn(exclude, container, insideName);
            if (result != null) {
                return result;
            }
            container = container.getContainer();
        }
        return null;
    }

    private static Variable _searchIn(Variable exclude, NamedObj container, String name) {
        Attribute result = container.getAttribute(name);
        if (result != null && result instanceof Variable && result != exclude) {
            return (Variable)result;
        }
        Iterator extenders = container.attributeList(ScopeExtender.class).iterator();
        if (extenders.hasNext()) {
            ScopeExtender extender = (ScopeExtender)extenders.next();
            result = extender.getAttribute(name);
            if (result != null && result instanceof Variable && result != exclude) {
                return (Variable)result;
            }
            return null;
        }
        return null;
    }
}

