/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.AbstractConvertibleToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.FixToken;
import ptolemy.data.MatrixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.util.StringUtilities;

public class StringToken
extends AbstractConvertibleToken {
    public static final StringToken NIL = new StringToken("nil");
    private String _value;
    private String _toString;

    public StringToken() {
        this("");
    }

    public StringToken(String value) {
        this._value = value == null ? "" : value;
        this._toString = "\"" + StringUtilities.escapeString(this._value) + "\"";
    }

    public static StringToken convert(Token token) throws IllegalActionException {
        if (token instanceof StringToken) {
            return (StringToken)token;
        }
        if (token == null || token.isNil()) {
            return NIL;
        }
        int compare = TypeLattice.compare((Type)BaseType.STRING, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(StringToken.notSupportedIncomparableConversionMessage(token, "string"));
        }
        if (token instanceof MatrixToken || token instanceof ScalarToken || token instanceof BooleanToken || token instanceof FixToken) {
            String str = token.toString();
            return new StringToken(str);
        }
        throw new IllegalActionException(StringToken.notSupportedConversionMessage(token, "string"));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this.isNil() || ((StringToken)object).isNil()) {
            return false;
        }
        return ((StringToken)object).stringValue().equals(this._value);
    }

    @Override
    public Type getType() {
        return BaseType.STRING;
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    @Override
    public boolean isNil() {
        return this == NIL;
    }

    public String stringValue() {
        if (this.isNil()) {
            return super.toString();
        }
        return this._value;
    }

    @Override
    public String toString() {
        if (this.isNil()) {
            return super.toString();
        }
        return this._toString;
    }

    @Override
    public Token zero() {
        return new StringToken("");
    }

    @Override
    protected Token _add(Token rightArgument) throws IllegalActionException {
        String result = this._value + ((StringToken)rightArgument).stringValue();
        return new StringToken(result);
    }

    @Override
    protected Token _divide(Token rightArgument) throws IllegalActionException {
        throw new IllegalActionException(StringToken.notSupportedMessage("divide", this, rightArgument));
    }

    @Override
    protected BooleanToken _isCloseTo(Token rightArgument, double epsilon) throws IllegalActionException {
        return this._isEqualTo(rightArgument);
    }

    @Override
    protected BooleanToken _isEqualTo(Token rightArgument) throws IllegalActionException {
        StringToken convertedArgument = (StringToken)rightArgument;
        return BooleanToken.getInstance(this.toString().compareTo(convertedArgument.toString()) == 0);
    }

    @Override
    protected Token _modulo(Token rightArgument) throws IllegalActionException {
        throw new IllegalActionException(StringToken.notSupportedMessage("modulo", this, rightArgument));
    }

    @Override
    protected Token _multiply(Token rightArgument) throws IllegalActionException {
        throw new IllegalActionException(StringToken.notSupportedMessage("multiply", this, rightArgument));
    }

    @Override
    protected Token _subtract(Token rightArgument) throws IllegalActionException {
        throw new IllegalActionException(StringToken.notSupportedMessage("subtract", this, rightArgument));
    }
}

