/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.data.unit.UnitUtilities;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.math.Complex;
import ptolemy.math.FixPoint;

public class ShortToken
extends ScalarToken {
    public static final ShortToken NIL = new ShortToken(Short.MAX_VALUE);
    public static final ShortToken ONE = new ShortToken(1);
    public static final ShortToken ZERO = new ShortToken(0);
    private final short _value;

    public ShortToken() {
        this._value = 0;
    }

    public ShortToken(short value) {
        this._value = value;
    }

    public ShortToken(int value) {
        this._value = (short)value;
    }

    public ShortToken(String init) throws IllegalActionException {
        if (init == null || init.equals("nil")) {
            throw new IllegalActionException(ShortToken.notSupportedNullNilStringMessage("ShortToken", init));
        }
        try {
            this._value = Short.parseShort(init);
        }
        catch (NumberFormatException e) {
            throw new IllegalActionException(null, e, "Failed to parse \"" + init + "\" as a number.");
        }
    }

    @Override
    public Complex complexValue() {
        return new Complex(this._value);
    }

    public static ShortToken convert(Token token) throws IllegalActionException {
        if (token instanceof ShortToken) {
            return (ShortToken)token;
        }
        if (token.isNil()) {
            return NIL;
        }
        int compare = TypeLattice.compare((Type)BaseType.SHORT, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(ShortToken.notSupportedIncomparableConversionMessage(token, "short"));
        }
        compare = TypeLattice.compare((Type)BaseType.UNSIGNED_BYTE, token);
        if (compare == 0 || compare == 1) {
            UnsignedByteToken unsignedByteToken = UnsignedByteToken.convert(token);
            ShortToken result = new ShortToken(unsignedByteToken.shortValue());
            if (unsignedByteToken._unitCategoryExponents != null && !UnitUtilities.isUnitless(unsignedByteToken._unitCategoryExponents)) {
                result._unitCategoryExponents = unsignedByteToken._copyOfCategoryExponents();
            }
            return result;
        }
        throw new IllegalActionException(ShortToken.notSupportedConversionMessage(token, "short"));
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        if (this.isNil() || ((ShortToken)object).isNil()) {
            return false;
        }
        return ((ShortToken)object).shortValue() == this._value;
    }

    @Override
    public FixPoint fixValue() {
        return new FixPoint(this._value);
    }

    @Override
    public float floatValue() {
        return this._value;
    }

    @Override
    public Type getType() {
        return BaseType.SHORT;
    }

    public int hashCode() {
        return this._value;
    }

    @Override
    public int intValue() {
        return this._value;
    }

    @Override
    public boolean isNil() {
        return this == NIL;
    }

    @Override
    public ScalarToken leftShift(int bits) {
        if (this.isNil()) {
            return NIL;
        }
        return new ShortToken(this._value << bits);
    }

    @Override
    public ScalarToken logicalRightShift(int bits) {
        if (this.isNil()) {
            return NIL;
        }
        short returnValue = (short)(this._value >>> bits);
        returnValue = (short)(returnValue & Short.MAX_VALUE);
        return new ShortToken(returnValue);
    }

    @Override
    public long longValue() {
        return this._value;
    }

    @Override
    public Token one() {
        return ONE;
    }

    @Override
    public ScalarToken rightShift(int bits) {
        if (this.isNil()) {
            return NIL;
        }
        return new ShortToken(this._value >> bits);
    }

    @Override
    public short shortValue() {
        return this._value;
    }

    @Override
    public String toString() {
        String unitString = "";
        if (!this._isUnitless()) {
            unitString = " * " + this.unitsString();
        }
        if (this.isNil()) {
            return super.toString();
        }
        return Short.toString(this._value) + unitString;
    }

    @Override
    public Token zero() {
        return ZERO;
    }

    @Override
    protected ScalarToken _absolute() {
        ShortToken result = this._value >= 0 ? this : new ShortToken((int)(-this._value));
        return result;
    }

    @Override
    protected ScalarToken _add(ScalarToken rightArgument) {
        short sum = (short)(this._value + ((ShortToken)rightArgument).shortValue());
        return new ShortToken(sum);
    }

    @Override
    protected ScalarToken _bitwiseAnd(ScalarToken rightArgument) {
        short sum = (short)(this._value & ((ShortToken)rightArgument).shortValue());
        return new ShortToken(sum);
    }

    @Override
    protected ScalarToken _bitwiseNot() {
        ShortToken result = new ShortToken((int)(~this._value));
        return result;
    }

    @Override
    protected ScalarToken _bitwiseOr(ScalarToken rightArgument) {
        short sum = (short)(this._value | ((ShortToken)rightArgument).shortValue());
        return new ShortToken(sum);
    }

    @Override
    protected ScalarToken _bitwiseXor(ScalarToken rightArgument) {
        short sum = (short)(this._value ^ ((ShortToken)rightArgument).shortValue());
        return new ShortToken(sum);
    }

    @Override
    protected ScalarToken _divide(ScalarToken rightArgument) {
        short quotient = (short)(this._value / ((ShortToken)rightArgument).shortValue());
        return new ShortToken(quotient);
    }

    @Override
    protected BooleanToken _isCloseTo(ScalarToken rightArgument, double epsilon) {
        double left;
        double right = ((ShortToken)rightArgument).doubleValue();
        if (right > (left = this.doubleValue()) + epsilon || right < left - epsilon) {
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    @Override
    protected BooleanToken _isLessThan(ScalarToken rightArgument) throws IllegalActionException {
        ShortToken convertedArgument = (ShortToken)rightArgument;
        return BooleanToken.getInstance(this._value < convertedArgument.shortValue());
    }

    @Override
    protected ScalarToken _modulo(ScalarToken rightArgument) {
        short remainder = (short)(this._value % ((ShortToken)rightArgument).shortValue());
        return new ShortToken(remainder);
    }

    @Override
    protected ScalarToken _multiply(ScalarToken rightArgument) {
        short product = (short)(this._value * ((ShortToken)rightArgument).shortValue());
        return new ShortToken(product);
    }

    @Override
    protected ScalarToken _subtract(ScalarToken rightArgument) {
        short difference = (short)(this._value - ((ShortToken)rightArgument).shortValue());
        return new ShortToken(difference);
    }
}

