/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import ptolemy.data.AbstractNotConvertibleToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.RecordType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;

public class RecordToken
extends AbstractNotConvertibleToken {
    private Map _fields = new TreeMap();

    public RecordToken(String[] labels, Token[] values) throws IllegalActionException {
        this._initialize(labels, values);
    }

    public RecordToken(String init) throws IllegalActionException {
        Token[] values;
        String[] labels;
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        ParseTreeEvaluator evaluator = new ParseTreeEvaluator();
        Token token = evaluator.evaluateParseTree(tree);
        if (token instanceof RecordToken) {
            RecordToken recordToken = (RecordToken)token;
            Object[] labelObjects = recordToken.labelSet().toArray();
            labels = new String[labelObjects.length];
            values = new Token[labelObjects.length];
            for (int i = 0; i < labelObjects.length; ++i) {
                labels[i] = (String)labelObjects[i];
                values[i] = recordToken.get(labels[i]);
            }
        } else {
            throw new IllegalActionException("A record token cannot be created from the expression '" + init + "'");
        }
        this._initialize(labels, values);
    }

    public RecordToken(Map fieldMap) throws IllegalActionException {
        for (Map.Entry entry : fieldMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalActionException("RecordToken: given map contains either null keys or null values.");
            }
            if (entry.getKey() instanceof String && entry.getValue() instanceof Token) continue;
            throw new IllegalActionException("RecordToken: given map contains either non-String keys or non-Token values.");
        }
        this._fields.putAll(fieldMap);
    }

    public boolean equals(Object object) {
        Set argLabelSet;
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        RecordToken recordToken = (RecordToken)object;
        Set myLabelSet = this._fields.keySet();
        if (!((Object)myLabelSet).equals(argLabelSet = recordToken._fields.keySet())) {
            return false;
        }
        for (String label : myLabelSet) {
            Token token2;
            Token token1 = this.get(label);
            if (token1.equals(token2 = recordToken.get(label))) continue;
            return false;
        }
        return true;
    }

    public Token get(String label) {
        return (Token)this._fields.get(label);
    }

    @Override
    public Type getType() {
        Object[] labelsObjects = this._fields.keySet().toArray();
        int size = labelsObjects.length;
        String[] labels = new String[size];
        Type[] types = new Type[size];
        for (int i = 0; i < size; ++i) {
            labels[i] = (String)labelsObjects[i];
            types[i] = this.get(labels[i]).getType();
        }
        return new RecordType(labels, types);
    }

    public int hashCode() {
        int code = 0;
        Set labelSet = this._fields.keySet();
        for (String label : labelSet) {
            Token token = this.get(label);
            code += token.hashCode();
        }
        return code;
    }

    public Set labelSet() {
        return this._fields.keySet();
    }

    public int length() {
        return this._fields.size();
    }

    public static RecordToken merge(RecordToken token1, RecordToken token2) {
        HashSet unionSet = new HashSet();
        Set labelSet1 = token1._fields.keySet();
        Set labelSet2 = token2._fields.keySet();
        unionSet.addAll(labelSet1);
        unionSet.addAll(labelSet2);
        Object[] labelsObjects = unionSet.toArray();
        int size = labelsObjects.length;
        String[] labels = new String[size];
        Token[] values = new Token[size];
        for (int i = 0; i < size; ++i) {
            labels[i] = (String)labelsObjects[i];
            Token value1 = token1.get(labels[i]);
            values[i] = value1 != null ? value1 : token2.get(labels[i]);
        }
        try {
            return new RecordToken(labels, values);
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(ex);
        }
    }

    public static Type mergeReturnType(Type type1, Type type2) {
        if (type1 instanceof RecordType && type2 instanceof RecordType) {
            RecordType recordType1 = (RecordType)type1;
            RecordType recordType2 = (RecordType)type2;
            HashSet unionSet = new HashSet();
            Set labelSet1 = recordType1.labelSet();
            Set labelSet2 = recordType2.labelSet();
            unionSet.addAll(labelSet1);
            unionSet.addAll(labelSet2);
            Object[] labelsObjects = unionSet.toArray();
            int size = labelsObjects.length;
            String[] labels = new String[size];
            Type[] types = new Type[size];
            for (int i = 0; i < size; ++i) {
                labels[i] = (String)labelsObjects[i];
                Type fieldType = recordType1.get(labels[i]);
                types[i] = fieldType != null ? fieldType : recordType2.get(labels[i]);
            }
            return new RecordType(labels, types);
        }
        return BaseType.UNKNOWN;
    }

    @Override
    public Token one() throws IllegalActionException {
        Object[] labelsObjects = this._fields.keySet().toArray();
        int size = labelsObjects.length;
        String[] labels = new String[size];
        Token[] values = new Token[size];
        for (int i = 0; i < size; ++i) {
            labels[i] = (String)labelsObjects[i];
            values[i] = this.get(labels[i]).one();
        }
        return new RecordToken(labels, values);
    }

    @Override
    public String toString() {
        Object[] labelsObjects = this._fields.keySet().toArray();
        int size = labelsObjects.length;
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                String labeli = (String)labelsObjects[i];
                String labelj = (String)labelsObjects[j];
                if (labeli.compareTo(labelj) < 0) continue;
                Object temp = labelsObjects[i];
                labelsObjects[i] = labelsObjects[j];
                labelsObjects[j] = temp;
            }
        }
        StringBuffer stringRepresentation = new StringBuffer("{");
        for (int i = 0; i < size; ++i) {
            String label = (String)labelsObjects[i];
            String value = this.get(label).toString();
            if (i != 0) {
                stringRepresentation.append(", ");
            }
            stringRepresentation.append(label + " = " + value);
        }
        return stringRepresentation.toString() + "}";
    }

    @Override
    public Token zero() throws IllegalActionException {
        Object[] labelsObjects = this._fields.keySet().toArray();
        int size = labelsObjects.length;
        String[] labels = new String[size];
        Token[] values = new Token[size];
        for (int i = 0; i < size; ++i) {
            labels[i] = (String)labelsObjects[i];
            values[i] = this.get(labels[i]).zero();
        }
        return new RecordToken(labels, values);
    }

    @Override
    protected Token _add(Token rightArgument) throws IllegalActionException {
        RecordToken recordToken = (RecordToken)rightArgument;
        HashSet intersectionSet = new HashSet();
        intersectionSet.addAll(this._fields.keySet());
        intersectionSet.retainAll(recordToken._fields.keySet());
        Iterator labels = intersectionSet.iterator();
        int size = intersectionSet.size();
        String[] newLabels = new String[size];
        Token[] newValues = new Token[size];
        int i = 0;
        while (labels.hasNext()) {
            String label = (String)labels.next();
            Token token1 = this.get(label);
            Token token2 = recordToken.get(label);
            newLabels[i] = label;
            newValues[i] = token1.add(token2);
            ++i;
        }
        return new RecordToken(newLabels, newValues);
    }

    @Override
    protected Token _divide(Token rightArgument) throws IllegalActionException {
        RecordToken recordToken = (RecordToken)rightArgument;
        HashSet intersectionSet = new HashSet();
        intersectionSet.addAll(this._fields.keySet());
        intersectionSet.retainAll(recordToken._fields.keySet());
        Iterator labels = intersectionSet.iterator();
        int size = intersectionSet.size();
        String[] newLabels = new String[size];
        Token[] newValues = new Token[size];
        int i = 0;
        while (labels.hasNext()) {
            String label = (String)labels.next();
            Token token1 = this.get(label);
            Token token2 = recordToken.get(label);
            newLabels[i] = label;
            newValues[i] = token1.divide(token2);
            ++i;
        }
        return new RecordToken(newLabels, newValues);
    }

    @Override
    protected BooleanToken _isCloseTo(Token rightArgument, double epsilon) throws IllegalActionException {
        Set argLabelSet;
        RecordToken recordToken = (RecordToken)rightArgument;
        Set myLabelSet = this._fields.keySet();
        if (!((Object)myLabelSet).equals(argLabelSet = recordToken._fields.keySet())) {
            return BooleanToken.FALSE;
        }
        for (String label : myLabelSet) {
            Token token2;
            Token token1 = this.get(label);
            BooleanToken result = token1.isCloseTo(token2 = recordToken.get(label), epsilon);
            if (result.booleanValue()) continue;
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    @Override
    protected BooleanToken _isEqualTo(Token rightArgument) throws IllegalActionException {
        Set argLabelSet;
        RecordToken recordToken = (RecordToken)rightArgument;
        Set myLabelSet = this._fields.keySet();
        if (!((Object)myLabelSet).equals(argLabelSet = recordToken._fields.keySet())) {
            return BooleanToken.FALSE;
        }
        for (String label : myLabelSet) {
            Token token2;
            Token token1 = this.get(label);
            BooleanToken result = token1.isEqualTo(token2 = recordToken.get(label));
            if (result.booleanValue()) continue;
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    @Override
    protected Token _modulo(Token rightArgument) throws IllegalActionException {
        RecordToken recordToken = (RecordToken)rightArgument;
        HashSet intersectionSet = new HashSet();
        intersectionSet.addAll(this._fields.keySet());
        intersectionSet.retainAll(recordToken._fields.keySet());
        Iterator labels = intersectionSet.iterator();
        int size = intersectionSet.size();
        String[] newLabels = new String[size];
        Token[] newValues = new Token[size];
        int i = 0;
        while (labels.hasNext()) {
            String label = (String)labels.next();
            Token token1 = this.get(label);
            Token token2 = recordToken.get(label);
            newLabels[i] = label;
            newValues[i] = token1.modulo(token2);
            ++i;
        }
        return new RecordToken(newLabels, newValues);
    }

    @Override
    protected Token _multiply(Token rightArgument) throws IllegalActionException {
        RecordToken recordToken = (RecordToken)rightArgument;
        HashSet intersectionSet = new HashSet();
        intersectionSet.addAll(this._fields.keySet());
        intersectionSet.retainAll(recordToken._fields.keySet());
        Iterator labels = intersectionSet.iterator();
        int size = intersectionSet.size();
        String[] newLabels = new String[size];
        Token[] newValues = new Token[size];
        int i = 0;
        while (labels.hasNext()) {
            String label = (String)labels.next();
            Token token1 = this.get(label);
            Token token2 = recordToken.get(label);
            newLabels[i] = label;
            newValues[i] = token1.multiply(token2);
            ++i;
        }
        return new RecordToken(newLabels, newValues);
    }

    @Override
    protected Token _subtract(Token rightArgument) throws IllegalActionException {
        RecordToken recordToken = (RecordToken)rightArgument;
        HashSet intersectionSet = new HashSet();
        intersectionSet.addAll(this._fields.keySet());
        intersectionSet.retainAll(recordToken._fields.keySet());
        Iterator labels = intersectionSet.iterator();
        int size = intersectionSet.size();
        String[] newLabels = new String[size];
        Token[] newValues = new Token[size];
        int i = 0;
        while (labels.hasNext()) {
            String label = (String)labels.next();
            Token token1 = this.get(label);
            Token token2 = recordToken.get(label);
            newLabels[i] = label;
            newValues[i] = token1.subtract(token2);
            ++i;
        }
        return new RecordToken(newLabels, newValues);
    }

    private void _initialize(String[] labels, Token[] values) throws IllegalActionException {
        if (labels == null || values == null || labels.length != values.length) {
            throw new IllegalActionException("RecordToken: the labels or the values array do not have the same length, or is null.");
        }
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i] == null || values[i] == null) {
                throw new IllegalActionException("RecordToken: the " + i + "'th element of the labels or values array is null");
            }
            if (this._fields.containsKey(labels[i])) {
                throw new IllegalActionException("RecordToken: The labels array contain duplicate element: " + labels[i]);
            }
            this._fields.put(labels[i], values[i]);
        }
    }
}

