/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.data;

import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.expr.ASTPtRootNode;
import ptolemy.data.expr.ParseTreeEvaluator;
import ptolemy.data.expr.PtParser;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.data.unit.UnitUtilities;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.math.Complex;

public class ComplexToken
extends ScalarToken {
    public static final ComplexToken NIL = new ComplexToken();
    private Complex _value = null;

    public ComplexToken() {
        this._value = Complex.ZERO;
    }

    public ComplexToken(Complex value) {
        this._value = value;
    }

    public ComplexToken(String init) throws IllegalActionException {
        PtParser parser = new PtParser();
        ASTPtRootNode tree = parser.generateParseTree(init);
        Token token = new ParseTreeEvaluator().evaluateParseTree(tree);
        if (!(token instanceof ComplexToken)) {
            throw new IllegalActionException("A ComplexToken cannot be created from the expression '" + init + "'");
        }
        this._value = ((ComplexToken)token).complexValue();
    }

    @Override
    public Complex complexValue() {
        return this._value;
    }

    public static ComplexToken convert(Token token) throws IllegalActionException {
        if (token instanceof ComplexToken) {
            return (ComplexToken)token;
        }
        if (token.isNil()) {
            return NIL;
        }
        int compare = TypeLattice.compare((Type)BaseType.COMPLEX, token);
        if (compare == -1 || compare == 2) {
            throw new IllegalActionException(ComplexToken.notSupportedIncomparableConversionMessage(token, "complex"));
        }
        compare = TypeLattice.compare((Type)BaseType.DOUBLE, token);
        if (compare == 0 || compare == 1) {
            DoubleToken doubleToken = DoubleToken.convert(token);
            ComplexToken result = new ComplexToken(doubleToken.complexValue());
            if (doubleToken._unitCategoryExponents != null && !UnitUtilities.isUnitless(doubleToken._unitCategoryExponents)) {
                result._unitCategoryExponents = doubleToken._copyOfCategoryExponents();
            }
            return result;
        }
        throw new IllegalActionException(ComplexToken.notSupportedConversionMessage(token, "complex"));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return ((ComplexToken)object).complexValue().equals(this._value);
    }

    @Override
    public boolean isNil() {
        return this == NIL;
    }

    @Override
    public Type getType() {
        return BaseType.COMPLEX;
    }

    public int hashCode() {
        return (int)this._value.magnitude();
    }

    @Override
    public Token one() {
        return new ComplexToken(new Complex(1.0));
    }

    @Override
    public String toString() {
        String unitString = "";
        if (!this._isUnitless()) {
            unitString = " * " + this.unitsString();
        }
        if (this.isNil()) {
            return super.toString();
        }
        return this._value.toString() + unitString;
    }

    @Override
    public Token zero() {
        return new ComplexToken(Complex.ZERO);
    }

    @Override
    protected ScalarToken _absolute() {
        DoubleToken result = new DoubleToken(this._value.magnitude());
        return result;
    }

    @Override
    protected ScalarToken _add(ScalarToken rightArgument) {
        Complex result = this._value.add(((ComplexToken)rightArgument).complexValue());
        return new ComplexToken(result);
    }

    @Override
    protected ScalarToken _bitwiseAnd(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(ComplexToken.notSupportedMessage("bitwiseAnd", this, rightArgument));
    }

    @Override
    protected ScalarToken _bitwiseNot() throws IllegalActionException {
        throw new IllegalActionException(ComplexToken.notSupportedMessage("bitwiseNot", this, this));
    }

    @Override
    protected ScalarToken _bitwiseOr(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(ComplexToken.notSupportedMessage("bitwiseOr", this, rightArgument));
    }

    @Override
    protected ScalarToken _bitwiseXor(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(ComplexToken.notSupportedMessage("bitwiseXor", this, rightArgument));
    }

    @Override
    protected ScalarToken _divide(ScalarToken rightArgument) throws IllegalActionException {
        Complex result = this._value.divide(((ComplexToken)rightArgument).complexValue());
        return new ComplexToken(result);
    }

    @Override
    protected BooleanToken _isCloseTo(ScalarToken rightArgument, double epsilon) {
        return BooleanToken.getInstance(this.complexValue().isCloseTo(((ComplexToken)rightArgument).complexValue(), epsilon));
    }

    @Override
    protected BooleanToken _isLessThan(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(ComplexToken.notSupportedMessage("isLessThan", this, rightArgument) + " because complex numbers cannot be compared.");
    }

    @Override
    protected ScalarToken _modulo(ScalarToken rightArgument) throws IllegalActionException {
        throw new IllegalActionException(ComplexToken.notSupportedMessage("modulo", this, rightArgument));
    }

    @Override
    protected ScalarToken _multiply(ScalarToken rightArgument) {
        Complex result = this._value.multiply(((ComplexToken)rightArgument).complexValue());
        return new ComplexToken(result);
    }

    @Override
    protected ScalarToken _subtract(ScalarToken rightArgument) {
        Complex result = this._value.subtract(((ComplexToken)rightArgument).complexValue());
        return new ComplexToken(result);
    }
}

