/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import ptolemy.actor.IOPort;
import ptolemy.actor.lib.vhdl.FixTransformer;
import ptolemy.data.FixToken;
import ptolemy.data.IntToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.math.FixPoint;
import ptolemy.math.FixPointQuantization;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Quantization;
import ptolemy.math.Rounding;

public abstract class SynchronousFixTransformer
extends FixTransformer {
    public Parameter latency = new Parameter((NamedObj)this, "latency", new IntToken(0));
    public Parameter initialValue = new Parameter(this, "initialValue");

    public SynchronousFixTransformer(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.initialValue.setTypeEquals(BaseType.SCALAR);
        this.initialValue.setExpression("0.0");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        super.attributeChanged(attribute);
        if (attribute == this.latency) {
            int latencyValue = ((ScalarToken)this.latency.getToken()).intValue();
            this.output.resize(latencyValue);
            try {
                if (latencyValue == 0) {
                    this.initialValue.setContainer(null);
                } else {
                    this.initialValue.setContainer(this);
                }
            }
            catch (NameDuplicationException ex) {
                throw new IllegalActionException((Nameable)this, ex, "Fail to set the initialValue parameter.");
            }
            Precision precision = new Precision(((Parameter)this.getAttribute("outputPrecision")).getExpression());
            Overflow overflow = Overflow.getName(((Parameter)this.getAttribute("outputOverflow")).getExpression().toLowerCase());
            Rounding rounding = Rounding.getName(((Parameter)this.getAttribute("outputRounding")).getExpression().toLowerCase());
            FixPoint result = new FixPoint(((ScalarToken)this.initialValue.getToken()).doubleValue(), (Quantization)new FixPointQuantization(precision, overflow, rounding));
            this.output.setInitToken(new FixToken(result));
        }
        if (attribute == this.initialValue) {
            Precision precision = new Precision(((Parameter)this.getAttribute("outputPrecision")).getExpression());
            Overflow overflow = Overflow.getName(((Parameter)this.getAttribute("outputOverflow")).getExpression().toLowerCase());
            Rounding rounding = Rounding.getName(((Parameter)this.getAttribute("outputRounding")).getExpression().toLowerCase());
            FixPoint result = new FixPoint(((ScalarToken)this.initialValue.getToken()).doubleValue(), (Quantization)new FixPointQuantization(precision, overflow, rounding));
            this.output.setInitToken(new FixToken(result));
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        Precision precision = new Precision(((Parameter)this.getAttribute("outputPrecision")).getExpression());
        Overflow overflow = Overflow.getName(((Parameter)this.getAttribute("outputOverflow")).getExpression().toLowerCase());
        Rounding rounding = Rounding.getName(((Parameter)this.getAttribute("outputRounding")).getExpression().toLowerCase());
        FixPoint result = new FixPoint(((ScalarToken)this.initialValue.getToken()).doubleValue(), (Quantization)new FixPointQuantization(precision, overflow, rounding));
        int latencyValue = ((ScalarToken)this.latency.getToken()).intValue();
        this.output.setSize(latencyValue, new FixToken(result));
    }

    @Override
    public boolean isStrict() {
        try {
            int latencyValue = ((ScalarToken)this.latency.getToken()).intValue();
            if (latencyValue > 0) {
                return false;
            }
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(this, (Throwable)ex, "Failed to get the value of the latency parameter?");
        }
        return true;
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        try {
            int latencyValue = ((ScalarToken)this.latency.getToken()).intValue();
            if (latencyValue > 0) {
                super.pruneDependencies();
                for (IOPort input : this.inputPortList()) {
                    this.removeDependency(input, this.output);
                }
            }
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(this, (Throwable)ex, "Failed to get the value of the latency parameter?");
        }
    }
}

