/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.SynchronousFixTransformer;
import ptolemy.data.FixToken;
import ptolemy.data.ScalarToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.math.FixPoint;
import ptolemy.math.Precision;

public class Memory
extends SynchronousFixTransformer {
    public Parameter capacity = new Parameter(this, "capacity");
    public TypedIOPort dataIn;
    public TypedIOPort writeEnable;
    public TypedIOPort address;
    private int _addressWidth;
    private int _capacity;
    private int _dataWidth;
    private FixToken[] _storage;

    public Memory(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.capacity.setExpression("1");
        this.writeEnable = new TypedIOPort(this, "writeEnable", true, false);
        this.writeEnable.setTypeEquals(BaseType.FIX);
        this.address = new TypedIOPort(this, "address", true, false);
        this.address.setTypeEquals(BaseType.FIX);
        this.dataIn = new TypedIOPort(this, "dataIn", true, false);
        this.dataIn.setTypeEquals(BaseType.FIX);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        super.attributeChanged(attribute);
        if (attribute == this.capacity) {
            this._capacity = ((ScalarToken)this.capacity.getToken()).intValue();
            this._addressWidth = (int)Math.floor(Math.log(this._capacity) / Math.log(2.0));
        } else if (attribute.getName().equals("outputPrecision")) {
            this._dataWidth = new Precision(this.getPortPrecision(this.output)).getNumberOfBits();
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.address.isKnown(0) && this.writeEnable.isKnown(0) && this.dataIn.isKnown(0)) {
            Token result;
            if (!(this.address.hasToken(0) && this.writeEnable.hasToken(0) && this.dataIn.hasToken(0))) {
                return;
            }
            FixToken in = (FixToken)this.dataIn.get(0);
            FixToken addressToken = (FixToken)this.address.get(0);
            FixPoint addressFixValue = addressToken.fixValue();
            FixToken writeEnableToken = (FixToken)this.writeEnable.get(0);
            FixPoint writeEnableValue = writeEnableToken.fixValue();
            this._checkFixTokenWidth(writeEnableToken, 1);
            this._checkFixTokenWidth(addressToken, this._addressWidth);
            this._checkFixTokenWidth(in, this._dataWidth);
            int addressValue = addressFixValue.getUnscaledValue().intValue();
            if (addressValue >= this._capacity) {
                throw new IllegalActionException((Nameable)this, "Address is out of range.");
            }
            if (writeEnableValue.toBitString().equals("1")) {
                this._storage[addressValue] = in;
            }
            if ((result = this._storage[addressValue]) == null) {
                result = Token.NIL;
            }
            this.sendOutput(this.output, 0, result);
        } else {
            this.output.resend(0);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._storage = new FixToken[this._capacity];
    }

    @Override
    public void pruneDependencies() {
        super.pruneDependencies();
        this.removeDependency(this.address, this.output);
        this.removeDependency(this.dataIn, this.output);
        this.removeDependency(this.writeEnable, this.output);
    }
}

