/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.vhdl;

import java.math.BigDecimal;
import java.math.BigInteger;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.vhdl.FixTransformer;
import ptolemy.data.FixToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.math.FixPoint;
import ptolemy.math.FixPointQuantization;
import ptolemy.math.Overflow;
import ptolemy.math.Precision;
import ptolemy.math.Quantization;
import ptolemy.math.Rounding;

public class Concat
extends FixTransformer {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);

    public Concat(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setMultiport(true);
        this.input.setTypeEquals(BaseType.FIX);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        Precision precision = new Precision(this.getPortPrecision(this.output));
        Overflow overflow = Overflow.getName(((Parameter)this.getAttribute("outputOverflow")).getExpression().toLowerCase());
        Rounding rounding = Rounding.getName(((Parameter)this.getAttribute("outputRounding")).getExpression().toLowerCase());
        StringBuffer bits = new StringBuffer();
        for (int i = 0; i < this.input.getWidth(); ++i) {
            if (!this.input.hasToken(i)) continue;
            FixToken in = (FixToken)this.input.get(i);
            bits.append(in.fixValue().toBitString());
        }
        FixPoint result = new FixPoint(new BigDecimal(new BigInteger(bits.toString(), 2)), (Quantization)new FixPointQuantization(precision, overflow, rounding));
        this.sendOutput(this.output, 0, new FixToken(result));
    }
}

