/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.security;

import java.io.Serializable;
import java.security.Key;
import ptolemy.data.BooleanToken;
import ptolemy.data.Token;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;

public class KeyToken
extends Token {
    public static final Type KEY = new KeyType();
    private Key _value;

    public KeyToken(Key value) {
        this._value = value;
    }

    @Override
    public Type getType() {
        return KEY;
    }

    public Key getValue() {
        return this._value;
    }

    @Override
    public final BooleanToken isEqualTo(Token rightArgument) throws IllegalActionException {
        byte[] leftEncoded;
        Key rightKey = ((KeyToken)rightArgument).getValue();
        Key leftKey = this.getValue();
        if (rightKey == null || leftKey == null) {
            return BooleanToken.FALSE;
        }
        if (!rightKey.getAlgorithm().equals(leftKey.getAlgorithm())) {
            return BooleanToken.FALSE;
        }
        if (!rightKey.getFormat().equals(leftKey.getFormat())) {
            return BooleanToken.FALSE;
        }
        byte[] rightEncoded = rightKey.getEncoded();
        if (rightEncoded.length != (leftEncoded = leftKey.getEncoded()).length) {
            return BooleanToken.FALSE;
        }
        for (int i = 0; i < rightEncoded.length; ++i) {
            if (rightEncoded[i] == leftEncoded[i]) continue;
            return BooleanToken.FALSE;
        }
        return BooleanToken.TRUE;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer("{ algorithm = " + this._value.getAlgorithm() + ", format = " + this._value.getFormat() + ", encoded = ");
        result.append(" Encoded: ");
        byte[] encoded = this._value.getEncoded();
        for (int i = 0; i < encoded.length - 1; ++i) {
            result.append(" " + encoded[i] + ",");
        }
        result.append(" " + encoded[encoded.length - 1] + ")");
        return result.toString();
    }

    public static class KeyType
    implements Type,
    Serializable {
        private KeyType() {
        }

        @Override
        public Type add(Type rightArgumentType) {
            return this;
        }

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public Token convert(Token token) throws IllegalActionException {
            if (token instanceof KeyToken) {
                return token;
            }
            throw new IllegalActionException("Attempt to convert token " + token + " into a Key token, which is not possible.");
        }

        @Override
        public Type divide(Type rightArgumentType) {
            return this;
        }

        @Override
        public Class getTokenClass() {
            return KeyToken.class;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isCompatible(Type type) {
            return type == this;
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        @Override
        public int getTypeHash() {
            return Integer.MIN_VALUE;
        }

        @Override
        public boolean isInstantiable() {
            return true;
        }

        @Override
        public boolean isSubstitutionInstance(Type type) {
            return this == type;
        }

        @Override
        public Type modulo(Type rightArgumentType) {
            return this;
        }

        @Override
        public Type multiply(Type rightArgumentType) {
            return this;
        }

        @Override
        public Type one() {
            return this;
        }

        @Override
        public Type subtract(Type rightArgumentType) {
            return this;
        }

        @Override
        public String toString() {
            return "Key";
        }

        @Override
        public Type zero() {
            return this;
        }
    }
}

