/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.security;

import javax.crypto.Cipher;
import ptolemy.actor.lib.security.CryptographyActor;
import ptolemy.data.StringToken;
import ptolemy.data.expr.StringParameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Settable;

public abstract class CipherActor
extends CryptographyActor {
    public StringParameter mode = new StringParameter(this, "mode");
    public StringParameter padding;
    protected Cipher _cipher;
    protected String _mode;
    protected String _padding;
    protected boolean _updateCipherNeeded = true;

    public CipherActor(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.mode.setVisibility(Settable.EXPERT);
        this.mode.setExpression("");
        this.mode.addChoice("");
        this.mode.addChoice("NONE");
        this.mode.addChoice("CBC");
        this.mode.addChoice("CFB");
        this.mode.addChoice("ECB");
        this.mode.addChoice("OFB");
        this.mode.addChoice("PCBC");
        this.padding = new StringParameter(this, "padding");
        this.padding.setVisibility(Settable.EXPERT);
        this.padding.setExpression("");
        this.padding.addChoice("");
        this.padding.addChoice("NoPadding");
        this.padding.addChoice("OAEPWithMD5AndMGF1Padding");
        this.padding.addChoice("PKCS5Padding");
        this.padding.addChoice("SSL3Padding");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.mode) {
            this._updateCipherNeeded = true;
            this._mode = ((StringToken)this.mode.getToken()).stringValue();
        } else if (attribute == this.padding) {
            this._updateCipherNeeded = true;
            this._padding = ((StringToken)this.padding.getToken()).stringValue();
        } else if (attribute == this.algorithm) {
            this._updateCipherNeeded = true;
            super.attributeChanged(attribute);
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this._updateCipher();
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._updateCipher();
    }

    protected void _updateCipher() throws IllegalActionException {
        if (this._updateCipherNeeded) {
            try {
                String paddingArgument;
                String modeArgument = this._mode.length() > 0 ? "/" + this._mode : "";
                String string = paddingArgument = this._padding.length() > 0 ? "/" + this._padding : "";
                if (this._mode.length() == 0 && this._padding.length() > 0) {
                    modeArgument = "/";
                }
                this._cipher = this._provider.equalsIgnoreCase("SystemDefault") ? Cipher.getInstance(this._algorithm + modeArgument + paddingArgument) : Cipher.getInstance(this._algorithm + modeArgument + paddingArgument, this._provider);
            }
            catch (Throwable throwable) {
                throw new IllegalActionException((Nameable)this, throwable, "Failed to initialize Cipher with algorithm: '" + this._algorithm + "', padding: '" + this._padding + "', provider: '" + this._provider + "'");
            }
            this._updateCipherNeeded = false;
        }
    }
}

