/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.javasound;

import java.io.IOException;
import ptolemy.actor.lib.Source;
import ptolemy.data.DoubleToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.media.javasound.SoundReader;

public class AudioReader
extends Source {
    public FileParameter fileOrURL = new FileParameter(this, "fileOrURL");
    private double[][] _audioIn;
    private DoubleToken[] _audioSendArray;
    private int _channels;
    private boolean _firedSinceWrapup = false;
    private String _previousFileOrURL;
    private boolean _reachedEOF = true;
    private int _sampleIndex;
    private SoundReader _soundReader;

    public AudioReader(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.fileOrURL.setExpression("$CLASSPATH/ptolemy/actor/lib/javasound/voice.wav");
        this.output.setMultiport(true);
        this.output.setTypeEquals(BaseType.DOUBLE);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.fileOrURL) {
            String newFileOrURL = ((StringToken)this.fileOrURL.getToken()).stringValue();
            if (this._previousFileOrURL != null && !newFileOrURL.equals(this._previousFileOrURL)) {
                this._previousFileOrURL = newFileOrURL;
                this._openReader();
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        if (this._firedSinceWrapup || this._soundReader == null) {
            this.fileOrURL.close();
            this._openReader();
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        int j;
        super.postfire();
        if (this._reachedEOF || this._soundReader == null) {
            return false;
        }
        this._firedSinceWrapup = true;
        if (this._audioSendArray == null || this._channels > this._audioSendArray.length) {
            this._audioSendArray = new DoubleToken[this._channels];
        }
        for (j = 0; j < this._channels; ++j) {
            this._audioSendArray[j] = new DoubleToken(this._audioIn[j][this._sampleIndex]);
        }
        ++this._sampleIndex;
        if (this._audioIn[0].length - this._sampleIndex <= 0) {
            try {
                this._audioIn = this._soundReader.getSamples();
            }
            catch (Exception ex) {
                throw new IllegalActionException((Nameable)this, ex, "Unable to get samples from the file.");
            }
            this._sampleIndex = 0;
            this._reachedEOF = this._audioIn == null;
        }
        for (j = 0; j < this._channels; ++j) {
            this.output.send(j, this._audioSendArray[j]);
        }
        return !this._reachedEOF;
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        this._firedSinceWrapup = true;
        if (this._reachedEOF || this._soundReader == null) {
            return false;
        }
        return super.prefire();
    }

    @Override
    public void wrapup() throws IllegalActionException {
        this.fileOrURL.close();
        this._soundReader = null;
        this._firedSinceWrapup = false;
    }

    protected void _openReader() throws IllegalActionException {
        this.fileOrURL.close();
        if (this.fileOrURL.getExpression().trim().equals("")) {
            this._soundReader = null;
            this._reachedEOF = true;
        } else {
            int getSamplesArraySize = 64;
            try {
                this._soundReader = new SoundReader(this.fileOrURL.asURL(), getSamplesArraySize);
            }
            catch (IOException ex) {
                String newFileOrURL = ((StringToken)this.fileOrURL.getToken()).stringValue();
                throw new IllegalActionException((Nameable)this, ex, "Cannot open fileOrURL '" + newFileOrURL + "'.");
            }
            this._channels = this._soundReader.getChannels();
            try {
                this._audioIn = this._soundReader.getSamples();
            }
            catch (Exception ex) {
                throw new IllegalActionException((Nameable)this, ex, "Unable to get samples from the file.");
            }
            this._sampleIndex = 0;
            this._reachedEOF = this._audioIn == null;
        }
    }
}

