/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.javasound;

import java.io.IOException;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.javasound.LiveSoundActor;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.media.javasound.LiveSound;

public class AudioPlayer
extends LiveSoundActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public Parameter input_tokenConsumptionRate;
    private double[][] _audioPutArray;

    public AudioPlayer(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.input.setMultiport(true);
        this.input_tokenConsumptionRate = new Parameter(this.input, "tokenConsumptionRate");
        this.input_tokenConsumptionRate.setTypeEquals(BaseType.INT);
        this.input_tokenConsumptionRate.setExpression("transferSize");
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        try {
            if (!LiveSound.isPlaybackActive()) {
                this._initializeAudio();
            }
            if (this._audioPutArray == null || this._channels != this._audioPutArray.length) {
                this._audioPutArray = new double[this._channels][];
            }
            for (int i = 0; i < this._channels; ++i) {
                this._audioPutArray[i] = new double[this._transferSize];
            }
            LiveSound.startPlayback(this);
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Error initializing audio playback.");
        }
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        super.prefire();
        for (int j = 0; j < this._channels; ++j) {
            if (this.input.hasToken(j, this._transferSize)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        for (int j = 0; j < this._channels; ++j) {
            Token[] inputArray = this.input.get(j, this._transferSize);
            for (int element = 0; element < this._transferSize; ++element) {
                this._audioPutArray[j][element] = ((DoubleToken)inputArray[element]).doubleValue();
            }
        }
        try {
            LiveSound.putSamples(this, this._audioPutArray);
        }
        catch (Exception ex) {
            throw new IllegalActionException((Nameable)this, ex, "Cannot playback audio.");
        }
        return true;
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        if (LiveSound.isPlaybackActive()) {
            try {
                LiveSound.stopPlayback(this);
            }
            catch (IOException ex) {
                throw new IllegalActionException((Nameable)this, ex, "Cannot free audio resources.");
            }
        }
    }
}

