/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.io;

import java.io.BufferedReader;
import java.io.IOException;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Source;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.StringToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.Workspace;

public class LineReader
extends Source {
    public TypedIOPort endOfFile;
    public FileParameter fileOrURL;
    public Parameter numberOfLinesToSkip;
    protected String _currentLine;
    protected BufferedReader _reader;
    private boolean _firedSinceWrapup = false;
    private String _previousFileOrURL;
    private boolean _reachedEOF = false;

    public LineReader(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeEquals(BaseType.STRING);
        this.endOfFile = new TypedIOPort(this, "endOfFile", false, true);
        this.endOfFile.setTypeEquals(BaseType.BOOLEAN);
        this.fileOrURL = new FileParameter(this, "fileOrURL");
        this.numberOfLinesToSkip = new Parameter(this, "numberOfLinesToSkip");
        this.numberOfLinesToSkip.setExpression("0");
        this.numberOfLinesToSkip.setTypeEquals(BaseType.INT);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-25\" y=\"-20\" width=\"50\" height=\"40\" style=\"fill:white\"/>\n<polygon points=\"-15,-10 -12,-10 -8,-14 -1,-14 3,-10 15,-10 15,10, -15,10\" style=\"fill:red\"/>\n</svg>\n");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.fileOrURL) {
            String newFileOrURL = ((StringToken)this.fileOrURL.getToken()).stringValue();
            if (this._previousFileOrURL != null && !newFileOrURL.equals(this._previousFileOrURL)) {
                this._previousFileOrURL = newFileOrURL;
                this.fileOrURL.close();
                this._reader = this.fileOrURL.getExpression().trim().equals("") ? null : this.fileOrURL.openForReading();
                this._reachedEOF = false;
            }
        } else if (attribute == this.numberOfLinesToSkip) {
            int linesToSkip = ((IntToken)this.numberOfLinesToSkip.getToken()).intValue();
            if (linesToSkip < 0) {
                throw new IllegalActionException((Nameable)this, "The number of lines to skip cannot be negative.");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        LineReader newObject = (LineReader)super.clone(workspace);
        newObject._currentLine = null;
        newObject._reachedEOF = false;
        newObject._reader = null;
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this._currentLine != null) {
            this.output.broadcast(new StringToken(this._currentLine));
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        if (this._firedSinceWrapup) {
            this.fileOrURL.close();
            this._reader = null;
            this._openAndReadFirstLine();
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._reader == null) {
            return false;
        }
        try {
            this._currentLine = this._reader.readLine();
            if (this._currentLine == null) {
                this._currentLine = "EOF";
                this._reachedEOF = true;
                this.endOfFile.broadcast(BooleanToken.TRUE);
                return false;
            }
            this.endOfFile.broadcast(BooleanToken.FALSE);
            return super.postfire();
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Postfire failed");
        }
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        this._firedSinceWrapup = true;
        if (this._reachedEOF) {
            return false;
        }
        return super.prefire();
    }

    @Override
    public void preinitialize() throws IllegalActionException {
        super.preinitialize();
        this._openAndReadFirstLine();
    }

    @Override
    public void wrapup() throws IllegalActionException {
        this.fileOrURL.close();
        this._reader = null;
        this._firedSinceWrapup = false;
    }

    private void _openAndReadFirstLine() throws IllegalActionException {
        this._reader = this.fileOrURL.openForReading();
        this._reachedEOF = false;
        try {
            int numberOfLines = ((IntToken)this.numberOfLinesToSkip.getToken()).intValue();
            for (int i = 0; i <= numberOfLines; ++i) {
                this._currentLine = this._reader.readLine();
                if (this._currentLine != null) continue;
                throw new IllegalActionException((Nameable)this, "The file '" + this.fileOrURL.stringValue() + "' does not " + "have enough lines.");
            }
        }
        catch (IOException ex) {
            throw new IllegalActionException((Nameable)this, ex, "Preinitialize failed.");
        }
    }
}

