/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.io;

import java.io.BufferedReader;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Source;
import ptolemy.data.StringToken;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class FileReader
extends Source {
    public FileParameter fileOrURL;
    public TypedIOPort fileOrURLPort;
    public Parameter newline;

    public FileReader(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeEquals(BaseType.STRING);
        this.fileOrURL = new FileParameter(this, "fileOrURL");
        this.fileOrURLPort = new TypedIOPort(this, "fileOrURL", true, false);
        this.fileOrURLPort.setTypeEquals(BaseType.STRING);
        this.newline = new Parameter(this, "newline");
        this.newline.setExpression("property(\"line.separator\")");
        this._attachText("_iconDescription", "<svg>\n<rect x=\"-25\" y=\"-20\" width=\"50\" height=\"40\" style=\"fill:white\"/>\n<polygon points=\"-15,-10 -12,-10 -8,-14 -1,-14 3,-10 15,-10 15,10, -15,10\" style=\"fill:red\"/>\n</svg>\n");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.fileOrURLPort.getWidth() > 0 && this.fileOrURLPort.hasToken(0)) {
            String name = ((StringToken)this.fileOrURLPort.get(0)).stringValue();
            this.fileOrURL.setExpression(name);
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = this.fileOrURL.openForReading();
            StringBuffer lineBuffer = new StringBuffer();
            String newlineValue = ((StringToken)this.newline.getToken()).stringValue();
            while ((line = reader.readLine()) != null) {
                lineBuffer = lineBuffer.append(line);
                lineBuffer = lineBuffer.append(newlineValue);
            }
            this.output.broadcast(new StringToken(lineBuffer.toString()));
        }
        catch (Throwable throwable) {
            throw new IllegalActionException((Nameable)this, throwable, "Failed to write '" + this.fileOrURL + "'");
        }
        finally {
            if (this.fileOrURL != null) {
                this.fileOrURL.close();
            }
        }
    }
}

