/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.image;

import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.AWTImageToken;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class URLToImage
extends Transformer {
    public URLToImage(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeEquals(BaseType.OBJECT);
        this.input.setTypeEquals(BaseType.STRING);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        StringToken urlToken = (StringToken)this.input.get(0);
        try {
            URL url = new URL(urlToken.stringValue());
            Image image = new ImageIcon(url).getImage();
            this.output.send(0, new AWTImageToken(image));
        }
        catch (MalformedURLException ex) {
            throw new IllegalActionException("'" + urlToken.stringValue() + "' is malformed: " + ex);
        }
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

