/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.image;

import java.awt.Image;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.ImageToken;
import ptolemy.data.StringToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class ImageToString
extends Transformer {
    public ImageToString(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setTypeEquals(BaseType.OBJECT);
        this.output.setTypeEquals(BaseType.STRING);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        int width = this.input.getWidth();
        for (int i = 0; i < width; ++i) {
            if (!this.input.hasToken(i)) continue;
            ImageToken imageToken = (ImageToken)this.input.get(i);
            Image image = imageToken.asAWTImage();
            String description = "Image: " + image.getWidth(null) + " x " + image.getHeight(null);
            StringToken out = new StringToken(description);
            this.output.broadcast(out);
        }
    }
}

