/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.io.File;
import java.net.URL;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Executable;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.IOPort;
import ptolemy.actor.Manager;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.parameters.FilePortParameter;
import ptolemy.actor.parameters.ParameterPort;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.LongToken;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLParser;

public class ModelReference
extends TypedAtomicActor
implements ExecutionListener {
    public StringParameter executionOnFiring;
    public Parameter lingerTime;
    public FilePortParameter modelFileOrURL;
    public StringParameter postfireAction;
    protected boolean _alreadyReadInputs = false;
    protected NamedObj _model;
    private static int _DO_NOTHING = 0;
    private static int _RUN_IN_CALLING_THREAD = 1;
    private static int _RUN_IN_A_NEW_THREAD = 2;
    private transient int _executionOnFiringValue = _RUN_IN_CALLING_THREAD;
    private transient boolean _executing = false;
    private Thread _lingeringThread = null;
    private Manager _manager = null;
    private transient int _postfireActionValue = _DO_NOTHING;
    private static int _STOP_EXECUTING = 1;
    private transient Throwable _throwable = null;

    public ModelReference(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.modelFileOrURL = new FilePortParameter(this, "modelFileOrURL");
        this.executionOnFiring = new StringParameter(this, "executionOnFiring");
        this.executionOnFiring.setExpression("run in calling thread");
        this.executionOnFiring.addChoice("run in calling thread");
        this.executionOnFiring.addChoice("run in a new thread");
        this.executionOnFiring.addChoice("do nothing");
        this.lingerTime = new Parameter(this, "lingerTime");
        this.lingerTime.setTypeEquals(BaseType.LONG);
        this.lingerTime.setExpression("0L");
        this.postfireAction = new StringParameter(this, "postfireAction");
        this.postfireAction.setExpression("do nothing");
        this.postfireAction.addChoice("do nothing");
        this.postfireAction.addChoice("stop executing");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.modelFileOrURL) {
            URL url;
            if (this._debugging) {
                this._debug("Setting modelFileOrURL to: " + this.modelFileOrURL.getExpression());
            }
            if ((url = this.modelFileOrURL.asURL()) != null) {
                File asFile;
                if (url.getProtocol().equals("file") && !(asFile = this.modelFileOrURL.asFile()).isFile()) {
                    throw new IllegalActionException((Nameable)this, "Not a file: " + url);
                }
                MoMLParser parser = new MoMLParser();
                try {
                    this._model = parser.parse(null, url);
                }
                catch (Exception ex) {
                    throw new IllegalActionException((Nameable)this, ex, "Failed to read model from: " + url);
                }
                if (!(this._model instanceof CompositeActor)) return;
                this._manager = new Manager(this._model.workspace(), "Manager");
                ((CompositeActor)this._model).setManager(this._manager);
                if (!this._debugging) return;
                this._debug("** Created new manager.");
                return;
            }
            this._model = null;
            this._manager = null;
            this._throwable = null;
            return;
        }
        if (attribute == this.executionOnFiring) {
            String executionOnFiringValue = this.executionOnFiring.stringValue();
            if (executionOnFiringValue.equals("run in calling thread")) {
                this._executionOnFiringValue = _RUN_IN_CALLING_THREAD;
                return;
            } else if (executionOnFiringValue.equals("run in a new thread")) {
                this._executionOnFiringValue = _RUN_IN_A_NEW_THREAD;
                return;
            } else {
                if (!executionOnFiringValue.equals("do nothing")) throw new IllegalActionException((Nameable)this, "Unrecognized option for executionOnFiring: " + executionOnFiringValue);
                this._executionOnFiringValue = _DO_NOTHING;
            }
            return;
        } else if (attribute == this.postfireAction) {
            String postfireActionValue = this.postfireAction.stringValue();
            if (postfireActionValue.equals("do nothing")) {
                this._postfireActionValue = _DO_NOTHING;
                return;
            } else {
                if (!postfireActionValue.equals("stop executing")) throw new IllegalActionException((Nameable)this, "Unrecognized value for postfireAction: " + postfireActionValue);
                this._postfireActionValue = _STOP_EXECUTING;
            }
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ModelReference newActor = (ModelReference)super.clone(workspace);
        newActor._manager = null;
        newActor._model = null;
        newActor._throwable = null;
        return newActor;
    }

    @Override
    public synchronized void executionError(Manager manager, Throwable throwable) {
        this._throwable = throwable;
        this._executing = false;
        manager.removeDebugListener(this);
        this.notifyAll();
    }

    @Override
    public synchronized void executionFinished(Manager manager) {
        this._executing = false;
        manager.removeDebugListener(this);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this._throwable != null) {
            Throwable throwable = this._throwable;
            this._throwable = null;
            throw new IllegalActionException((Nameable)this, throwable, "Run in a new thread threw an exception on the previous firing.");
        }
        if (!this._alreadyReadInputs) {
            this._readInputsAndValidateSettables();
        }
        this._alreadyReadInputs = false;
        if (this._model instanceof CompositeActor) {
            NamedObj director;
            CompositeActor executable = (CompositeActor)this._model;
            this._manager = executable.getManager();
            if (this._manager == null) {
                throw new InternalErrorException("No manager!");
            }
            if (this._debugging) {
                this._manager.addDebugListener(this);
                director = executable.getDirector();
                if (director != null) {
                    director.addDebugListener(this);
                }
            } else {
                this._manager.removeDebugListener(this);
                director = executable.getDirector();
                if (director != null) {
                    director.removeDebugListener(this);
                }
            }
            if (this._executing) {
                director = this;
                synchronized (director) {
                    while (this._executing) {
                        try {
                            if (this._debugging) {
                                this._debug("** Waiting for previous execution to finish.");
                            }
                            this.workspace().wait(this);
                        }
                        catch (InterruptedException ex) {
                            this.getManager().finish();
                            return;
                        }
                    }
                    if (this._debugging) {
                        this._debug("** Previous execution has finished.");
                    }
                }
            }
            if (this._executionOnFiringValue == _RUN_IN_CALLING_THREAD) {
                if (this._debugging) {
                    this._debug("** Executing referenced model in the calling thread.");
                }
                try {
                    this._manager.execute();
                }
                catch (KernelException ex) {
                    throw new IllegalActionException((Nameable)this, ex, "Execution failed.");
                }
                this._writeOutputs();
            } else if (this._executionOnFiringValue == _RUN_IN_A_NEW_THREAD) {
                if (this._debugging) {
                    this._debug("** Creating a new thread to execute the model.");
                }
                this._manager.addExecutionListener(this);
                if (this._manager.getState() != Manager.IDLE) {
                    throw new IllegalActionException((Nameable)this, "Cannot start an execution. Referenced model is " + this._manager.getState().getDescription());
                }
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            if (ModelReference.this._debugging) {
                                ModelReference.this._debug("** Executing model in a new thread.");
                            }
                            ModelReference.this._manager.execute();
                            ModelReference.this._writeOutputs();
                        }
                        catch (Throwable throwable) {
                            ModelReference.this._manager.notifyListenersOfThrowable(throwable);
                        }
                    }
                };
                thread.setPriority(1);
                thread.start();
            }
            long lingerTimeValue = ((LongToken)this.lingerTime.getToken()).longValue();
            if (lingerTimeValue > 0L) {
                try {
                    if (this._debugging) {
                        this._debug("** Lingering for " + lingerTimeValue + " milliseconds.");
                    }
                    this._lingeringThread = Thread.currentThread();
                    Thread.sleep(lingerTimeValue);
                }
                catch (InterruptedException ex) {
                }
                finally {
                    this._lingeringThread = null;
                }
            }
        }
    }

    @Override
    public void managerStateChanged(Manager manager) {
        if (this._debugging) {
            this._debug("Referenced model manager state: " + manager.getState());
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._postfireActionValue == _STOP_EXECUTING && this._manager != null) {
            if (this._debugging) {
                this._debug("** Calling finish() on the Manager to request termination.");
            }
            this._manager.finish();
            if (this._debugging) {
                this._debug("** Waiting for completion of execution.");
            }
            this._manager.waitForCompletion();
        }
        if (this._manager != null) {
            this._manager.removeExecutionListener(this);
            this._manager = null;
        }
        return super.postfire();
    }

    @Override
    public void stop() {
        if (this._model instanceof Executable) {
            ((Executable)((Object)this._model)).stop();
        }
        if (this._lingeringThread != null) {
            this._lingeringThread.interrupt();
        }
        super.stop();
    }

    @Override
    public void stopFire() {
        if (this._model instanceof Executable) {
            ((Executable)((Object)this._model)).stopFire();
        }
        if (this._lingeringThread != null) {
            this._lingeringThread.interrupt();
        }
        super.stopFire();
    }

    @Override
    public void terminate() {
        if (this._model instanceof Executable) {
            ((Executable)((Object)this._model)).terminate();
        }
        super.terminate();
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        this._alreadyReadInputs = false;
        if (this._throwable != null) {
            Throwable throwable = this._throwable;
            this._throwable = null;
            throw new IllegalActionException((Nameable)this, throwable, "Background run threw an exception");
        }
    }

    protected void _readInputsAndValidateSettables() throws IllegalActionException {
        if (this._debugging) {
            this._debug("** Reading inputs (if any).");
        }
        boolean changeMade = false;
        for (IOPort port : this.inputPortList()) {
            if (port instanceof ParameterPort) {
                PortParameter parameter = ((ParameterPort)port).getParameter();
                if (this._debugging) {
                    this._debug("** Updating PortParameter: " + port.getName());
                }
                parameter.update();
                changeMade = true;
                continue;
            }
            if (port.getWidth() <= 0 || !port.hasToken(0)) continue;
            Token token = port.get(0);
            if (this._model == null) continue;
            Attribute attribute = this._model.getAttribute(port.getName());
            if (attribute instanceof Variable) {
                if (this._debugging) {
                    this._debug("** Transferring input to parameter: " + port.getName());
                }
                ((Variable)attribute).setToken(token);
                changeMade = true;
                continue;
            }
            if (!(attribute instanceof Settable)) continue;
            if (this._debugging) {
                this._debug("** Transferring input as string to parameter: " + port.getName());
            }
            ((Settable)((Object)attribute)).setExpression(token.toString());
            changeMade = true;
        }
        if (changeMade) {
            this._model.validateSettables();
        }
    }

    private void _writeOutputs() throws IllegalActionException {
        if (this._debugging) {
            this._debug("** Writing outputs (if any).");
        }
        for (IOPort port : this.outputPortList()) {
            if (port.getWidth() <= 0) continue;
            Attribute attribute = this._model.getAttribute(port.getName());
            if (attribute instanceof Variable) {
                if (this._debugging) {
                    this._debug("** Transferring parameter to output: " + port.getName());
                }
                port.send(0, ((Variable)attribute).getToken());
                continue;
            }
            if (!(attribute instanceof Settable)) continue;
            if (this._debugging) {
                this._debug("** Transferring parameter as string to output: " + port.getName());
            }
            port.send(0, new StringToken(((Settable)((Object)attribute)).getExpression()));
        }
    }
}

