/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.FiringEvent;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoRoomException;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.QueueReceiver;
import ptolemy.actor.Receiver;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.hoc.MirrorComposite;
import ptolemy.actor.lib.hoc.MirrorPort;
import ptolemy.actor.util.Time;
import ptolemy.data.ArrayToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.data.type.TypeLattice;
import ptolemy.graph.Inequality;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Port;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;

public class IterateOverArray
extends MirrorComposite {
    private Variable _iterationCount;

    public IterateOverArray(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.setClassName("ptolemy.actor.lib.hoc.IterateOverArray");
        new IterateDirector(this, this.uniqueName("IterateDirector"));
        this._iterationCount = new Variable((NamedObj)this, "iterationCount", new IntToken(0));
        this._iterationCount.setTypeEquals(BaseType.INT);
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        IterateOverArray result = (IterateOverArray)super.clone(workspace);
        result._iterationCount = (Variable)result.getAttribute("iterationCount");
        return result;
    }

    @Override
    public Port newPort(String name) throws NameDuplicationException {
        try {
            IteratePort result = new IteratePort(this, name);
            return result;
        }
        catch (IllegalActionException ex) {
            throw new InternalErrorException(this, (Throwable)ex, null);
        }
    }

    @Override
    public List typeConstraintList() throws IllegalActionException {
        for (TypedIOPort port : this.portList()) {
            port.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        }
        return super.typeConstraintList();
    }

    @Override
    protected List _checkTypesFromTo(TypedIOPort sourcePort, List destinationPortList) {
        LinkedList<Inequality> result = new LinkedList<Inequality>();
        boolean isUndeclared = sourcePort.getTypeTerm().isSettable();
        if (!isUndeclared) {
            Type srcDeclared = sourcePort.getType();
            for (TypedIOPort destinationPort : destinationPortList) {
                int compare;
                isUndeclared = destinationPort.getTypeTerm().isSettable();
                if (isUndeclared) continue;
                Type destinationDeclared = destinationPort.getType();
                if (sourcePort.getContainer() == this && destinationPort.getContainer() != this) {
                    Type srcElementType = ((ArrayType)srcDeclared).getElementType();
                    compare = TypeLattice.compare(srcElementType, destinationDeclared);
                } else if (sourcePort.getContainer() != this && destinationPort.getContainer() == this) {
                    Type destinationElementType = ((ArrayType)destinationDeclared).getElementType();
                    compare = TypeLattice.compare(srcDeclared, destinationElementType);
                } else {
                    compare = TypeLattice.compare(srcDeclared, destinationDeclared);
                }
                if (compare != 1 && compare != 2) continue;
                Inequality inequality = new Inequality(sourcePort.getTypeTerm(), destinationPort.getTypeTerm());
                result.add(inequality);
            }
        }
        return result;
    }

    @Override
    protected List _typeConstraintsFromTo(TypedIOPort sourcePort, List destinationPortList) {
        LinkedList<Inequality> result = new LinkedList<Inequality>();
        boolean srcUndeclared = sourcePort.getTypeTerm().isSettable();
        for (TypedIOPort destinationPort : destinationPortList) {
            boolean destUndeclared = destinationPort.getTypeTerm().isSettable();
            if (!srcUndeclared && !destUndeclared) continue;
            if (sourcePort.getContainer() == this && destinationPort.getContainer() == this) {
                Inequality ineq1 = new Inequality(sourcePort.getTypeTerm(), destinationPort.getTypeTerm());
                result.add(ineq1);
                Inequality ineq2 = new Inequality(destinationPort.getTypeTerm(), sourcePort.getTypeTerm());
                result.add(ineq2);
                continue;
            }
            if (sourcePort.getContainer().equals(this)) {
                if (sourcePort.sourcePortList().size() == 0) continue;
                Inequality arrayInequality = new Inequality(ArrayType.ARRAY_BOTTOM, sourcePort.getTypeTerm());
                result.add(arrayInequality);
                try {
                    Inequality ineq = new Inequality(ArrayType.elementType(sourcePort), destinationPort.getTypeTerm());
                    result.add(ineq);
                    continue;
                }
                catch (IllegalActionException e) {
                    throw new InternalErrorException(e);
                }
            }
            if (!destinationPort.getContainer().equals(this)) continue;
            try {
                Inequality ineq = new Inequality(ArrayType.arrayOf(sourcePort), destinationPort.getTypeTerm());
                result.add(ineq);
            }
            catch (IllegalActionException e) {
                throw new InternalErrorException(e);
            }
        }
        return result;
    }

    public static class IteratePort
    extends MirrorPort {
        public IteratePort(Workspace workspace) {
            super(workspace);
        }

        public IteratePort(TypedCompositeActor container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        @Override
        public Token convert(Token token) throws IllegalActionException {
            if (!(this.getContainer() instanceof IterateOverArray) || !this.isOutput()) {
                return super.convert(token);
            }
            Type type = ((ArrayType)this.getType()).getElementType();
            if (((Object)type).equals(token.getType())) {
                return token;
            }
            Token newToken = type.convert(token);
            return newToken;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendInside(int channelIndex, Token token) throws IllegalActionException, NoRoomException {
            if (!(this.getContainer() instanceof IterateOverArray)) {
                super.sendInside(channelIndex, token);
                return;
            }
            if (this._debugging) {
                this._debug("send inside to channel " + channelIndex + ": " + token);
            }
            try {
                Receiver[][] farReceivers;
                try {
                    this._workspace.getReadAccess();
                    ArrayType type = (ArrayType)this.getType();
                    int compare = TypeLattice.compare(token.getType(), type.getElementType());
                    if (compare == 1 || compare == 2) {
                        throw new IllegalActionException("Run-time type checking failed. Token type: " + ((Object)token.getType()).toString() + ", port: " + this.getFullName() + ", port type: " + ((Object)this.getType()).toString());
                    }
                    farReceivers = this.deepGetReceivers();
                    if (farReceivers == null || farReceivers[channelIndex] == null) {
                        return;
                    }
                }
                finally {
                    this._workspace.doneReading();
                }
                for (int j = 0; j < farReceivers[channelIndex].length; ++j) {
                    TypedIOPort port = (TypedIOPort)farReceivers[channelIndex][j].getContainer();
                    Token newToken = port.convert(token);
                    farReceivers[channelIndex][j].put(newToken);
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                // empty catch block
            }
        }
    }

    private class IterateDirector
    extends Director {
        private boolean _postfireReturns;

        public IterateDirector(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
            this._postfireReturns = true;
            this.setPersistent(false);
        }

        @Override
        public void fire() throws IllegalActionException {
            CompositeActor container = (CompositeActor)this.getContainer();
            Iterator actors = container.entityList().iterator();
            this._postfireReturns = true;
            block0: while (actors.hasNext() && !this._stopRequested) {
                Actor actor = (Actor)actors.next();
                if (!((ComponentEntity)((Object)actor)).isOpaque()) {
                    throw new IllegalActionException((Nameable)container, "Inside actor is not opaque (perhaps it needs a director).");
                }
                int result = 0;
                int iterationCount = 0;
                while (result != 1) {
                    IterateOverArray.this._iterationCount.setToken(new IntToken(++iterationCount));
                    if (this._debugging) {
                        this._debug(new FiringEvent(this, actor, FiringEvent.BEFORE_ITERATE, iterationCount));
                    }
                    result = actor.iterate(1);
                    if (this._debugging) {
                        this._debug(new FiringEvent(this, actor, FiringEvent.AFTER_ITERATE, iterationCount));
                    }
                    boolean outOfData = true;
                    block2: for (IOPort port : actor.inputPortList()) {
                        for (int i = 0; i < port.getWidth(); ++i) {
                            if (!port.hasToken(i)) continue;
                            outOfData = false;
                            continue block2;
                        }
                    }
                    if (outOfData) {
                        if (!this._debugging) continue block0;
                        this._debug("No more input data for: " + actor.getFullName());
                        continue block0;
                    }
                    if (result != 2) continue;
                    if (this._debugging) {
                        this._debug("Actor requests halt: " + actor.getFullName());
                    }
                    this._postfireReturns = false;
                    continue block0;
                }
            }
        }

        @Override
        public void fireAt(Actor actor, Time time) throws IllegalActionException {
            Director director = IterateOverArray.this.getExecutiveDirector();
            if (director != null) {
                director.fireAt(actor, time);
            }
        }

        @Override
        public void fireAtCurrentTime(Actor actor) throws IllegalActionException {
            Director director = IterateOverArray.this.getExecutiveDirector();
            if (director != null) {
                director.fireAtCurrentTime(actor);
            }
        }

        @Override
        public Receiver newReceiver() {
            return new QueueReceiver();
        }

        @Override
        public boolean postfire() throws IllegalActionException {
            boolean superReturns = super.postfire();
            return superReturns && this._postfireReturns;
        }

        @Override
        public boolean transferInputs(IOPort port) throws IllegalActionException {
            boolean result = false;
            for (int i = 0; i < port.getWidth(); ++i) {
                try {
                    if (!port.isKnown(i) || !port.hasToken(i)) continue;
                    Token t = port.get(i);
                    if (this._debugging) {
                        this._debug(this.getName(), "transferring input from " + port.getName());
                    }
                    ArrayToken arrayToken = (ArrayToken)t;
                    for (int j = 0; j < arrayToken.length(); ++j) {
                        port.sendInside(i, arrayToken.getElement(j));
                    }
                    result = true;
                    continue;
                }
                catch (NoTokenException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, null);
                }
            }
            return result;
        }

        @Override
        public boolean transferOutputs(IOPort port) throws IllegalActionException {
            boolean result = false;
            ArrayType type = (ArrayType)((TypedIOPort)port).getType();
            Type elementType = type.getElementType();
            for (int i = 0; i < port.getWidthInside(); ++i) {
                try {
                    ArrayList<Token> list = new ArrayList<Token>();
                    while (port.isKnownInside(i) && port.hasTokenInside(i)) {
                        Token t = port.getInside(i);
                        list.add(t);
                    }
                    if (list.size() != 0) {
                        Token[] tokens = list.toArray(new Token[list.size()]);
                        if (this._debugging) {
                            this._debug(this.getName(), "transferring output to " + port.getName());
                        }
                        port.send(i, new ArrayToken(elementType, tokens));
                    } else {
                        port.send(i, new ArrayToken(elementType));
                    }
                    result = true;
                    continue;
                }
                catch (NoTokenException ex) {
                    throw new InternalErrorException(this, (Throwable)ex, null);
                }
            }
            return result;
        }
    }

    public static class IterateComposite
    extends MirrorComposite.MirrorCompositeContents {
        public IterateComposite(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
            super(container, name);
        }

        @Override
        public Port newPort(String name) throws NameDuplicationException {
            try {
                return new IteratePort(this, name);
            }
            catch (IllegalActionException ex) {
                throw new InternalErrorException(this, (Throwable)ex, null);
            }
        }
    }
}

