/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.hoc;

import java.net.URL;
import java.util.LinkedList;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Director;
import ptolemy.actor.Executable;
import ptolemy.actor.ExecutionListener;
import ptolemy.actor.Manager;
import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.ArrayToken;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.FileParameter;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.Variable;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.InternalErrorException;
import ptolemy.kernel.util.KernelException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLParser;

public class ApplyFilterOverArray
extends TypedAtomicActor
implements ExecutionListener {
    public TypedIOPort inputArray = new TypedIOPort(this, "inputArray", true, false);
    public TypedIOPort outputArray;
    public Parameter maxOutputLength;
    public FileParameter modelFileOrURL;
    protected NamedObj _model;
    private Manager _manager = null;
    private int _outputLength = 1;
    private transient Throwable _throwable = null;

    public ApplyFilterOverArray(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.inputArray.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        this.outputArray = new TypedIOPort(this, "outputArray", false, true);
        this.outputArray.setTypeSameAs(this.inputArray);
        this.modelFileOrURL = new FileParameter(this, "modelFileOrURL");
        this.maxOutputLength = new Parameter(this, "maxOutputLength");
        this.maxOutputLength.setTypeEquals(BaseType.INT);
        this.maxOutputLength.setExpression("1");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.modelFileOrURL) {
            URL url = this.modelFileOrURL.asURL();
            if (url != null) {
                MoMLParser parser = new MoMLParser();
                try {
                    this._model = parser.parse(null, url);
                }
                catch (Exception ex) {
                    throw new IllegalActionException((Nameable)this, ex, "Failed to read model.");
                }
                if (!(this._model instanceof CompositeActor)) return;
                this._manager = new Manager(this._model.workspace(), "Manager");
                ((CompositeActor)this._model).setManager(this._manager);
                if (!this._debugging) return;
                this._debug("** Created new manager.");
                return;
            }
            this._model = null;
            this._manager = null;
            this._throwable = null;
            return;
        }
        if (attribute == this.maxOutputLength) {
            IntToken length = (IntToken)this.maxOutputLength.getToken();
            if (length.intValue() <= 0) throw new IllegalActionException((Nameable)this, "output array length is less than or equal 0?!");
            this._outputLength = length.intValue();
            return;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        ApplyFilterOverArray newActor = (ApplyFilterOverArray)super.clone(workspace);
        newActor._manager = null;
        newActor._model = null;
        newActor._throwable = null;
        newActor.inputArray.setTypeAtLeast(ArrayType.ARRAY_BOTTOM);
        newActor.outputArray.setTypeSameAs(newActor.inputArray);
        return newActor;
    }

    @Override
    public synchronized void executionError(Manager manager, Throwable throwable) {
        this._throwable = throwable;
        manager.removeDebugListener(this);
        this.notifyAll();
    }

    @Override
    public synchronized void executionFinished(Manager manager) {
        manager.removeDebugListener(this);
        this.notifyAll();
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this._model instanceof CompositeActor) {
            Director director;
            CompositeActor executable = (CompositeActor)this._model;
            this._manager = executable.getManager();
            if (this._manager == null) {
                throw new InternalErrorException("No manager!");
            }
            if (this._debugging) {
                this._manager.addDebugListener(this);
                director = executable.getDirector();
                if (director != null) {
                    director.addDebugListener(this);
                }
            } else {
                this._manager.removeDebugListener(this);
                director = executable.getDirector();
                if (director != null) {
                    director.removeDebugListener(this);
                }
            }
            int i = 0;
            LinkedList<Token> list = new LinkedList<Token>();
            ArrayToken array = (ArrayToken)this.inputArray.get(0);
            for (int j = 0; i < this._outputLength && j < array.length(); ++j) {
                Token t = array.getElement(j);
                this._updateParameter(t);
                if (this._debugging) {
                    this._debug("** Executing filter model.");
                }
                try {
                    this._manager.execute();
                }
                catch (KernelException ex) {
                    throw new IllegalActionException((Nameable)this, ex, "Execution failed.");
                }
                if (!this._getResult()) continue;
                ++i;
                list.add(t);
            }
            Token[] result = new Token[list.size()];
            for (i = 0; i < list.size(); ++i) {
                result[i] = (Token)list.get(i);
            }
            this.outputArray.send(0, new ArrayToken(array.getElementType(), result));
        }
    }

    @Override
    public void managerStateChanged(Manager manager) {
        if (this._debugging) {
            this._debug("Referenced model manager state: " + manager.getState());
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        if (this._manager != null) {
            this._manager.removeExecutionListener(this);
            this._manager = null;
        }
        return super.postfire();
    }

    @Override
    public void stop() {
        if (this._model instanceof Executable) {
            ((Executable)((Object)this._model)).stop();
        }
        super.stop();
    }

    @Override
    public void stopFire() {
        if (this._model instanceof Executable) {
            ((Executable)((Object)this._model)).stopFire();
        }
        super.stopFire();
    }

    @Override
    public void terminate() {
        if (this._model instanceof Executable) {
            ((Executable)((Object)this._model)).terminate();
        }
        super.terminate();
    }

    @Override
    public void wrapup() throws IllegalActionException {
        super.wrapup();
        if (this._throwable != null) {
            Throwable throwable = this._throwable;
            this._throwable = null;
            throw new IllegalActionException((Nameable)this, throwable, "Background run threw an exception");
        }
    }

    private void _updateParameter(Token t) throws IllegalActionException {
        Attribute attribute = this._model.getAttribute("inputArrayElement");
        if (attribute instanceof Variable) {
            if (this._debugging) {
                this._debug("** Transferring input to parameter inputArrayElement.");
            }
            ((Variable)attribute).setToken(t);
        } else if (attribute instanceof Settable) {
            if (this._debugging) {
                this._debug("** Transferring input as string to inputArrayElement.");
            }
            ((Settable)((Object)attribute)).setExpression(t.toString());
        } else {
            throw new IllegalActionException((Nameable)this, "The specified model does not have an inputArrayElement parameter.");
        }
    }

    private boolean _getResult() throws IllegalActionException {
        Attribute attribute = this._model.getAttribute("evaluatedValue");
        if (attribute instanceof Variable) {
            Token t = ((Variable)attribute).getToken();
            return ((BooleanToken)t).booleanValue();
        }
        if (attribute instanceof Settable) {
            BooleanToken t = new BooleanToken(((Settable)((Object)attribute)).getExpression());
            return t.booleanValue();
        }
        throw new IllegalActionException((Nameable)this, "The specified model does not have an evaluatedValue parameter.");
    }
}

