/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import java.awt.Color;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ptolemy.actor.gui.Placeable;
import ptolemy.actor.lib.Source;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.kernel.util.Workspace;

public class SliderSource
extends Source
implements ChangeListener,
Placeable {
    public JSlider slider;
    public Parameter minimum;
    public Parameter maximum;
    public Parameter majorTickSpacing;
    public Parameter minorTickSpacing;
    public StringAttribute title;
    private JPanel _panel;
    private Container _container;
    private int _val;
    private IntToken _outputVal;
    private JFrame _frame;

    public SliderSource(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.output.setTypeEquals(BaseType.INT);
        this.minimum = new Parameter((NamedObj)this, "minimum", new IntToken(-10));
        this.minimum.setTypeEquals(BaseType.INT);
        this.maximum = new Parameter((NamedObj)this, "maximum", new IntToken(10));
        this.maximum.setTypeEquals(BaseType.INT);
        this.majorTickSpacing = new Parameter((NamedObj)this, "majorTickSpacing", new IntToken(10));
        this.majorTickSpacing.setTypeEquals(BaseType.INT);
        this.minorTickSpacing = new Parameter((NamedObj)this, "minorTickSpacing", new IntToken(1));
        this.minorTickSpacing.setTypeEquals(BaseType.INT);
        this.title = new StringAttribute(this, "title");
        this.title.setExpression("");
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.minimum || attribute == this.maximum || attribute == this.majorTickSpacing || attribute == this.minorTickSpacing) {
            int min = ((IntToken)this.minimum.getToken()).intValue();
            int max = ((IntToken)this.maximum.getToken()).intValue();
            int major = ((IntToken)this.majorTickSpacing.getToken()).intValue();
            int minor = ((IntToken)this.minorTickSpacing.getToken()).intValue();
            if (min > max) {
                throw new IllegalActionException((Nameable)this, "The minimum value of the slider cannot be larger than the maximum value.");
            }
            if (this.slider != null) {
                this.slider.setMaximum(max);
                this.slider.setMinimum(min);
                this.slider.setMajorTickSpacing(major);
                this.slider.setMinorTickSpacing(minor);
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public Object clone(Workspace workspace) throws CloneNotSupportedException {
        SliderSource newObject = (SliderSource)super.clone(workspace);
        newObject.slider = null;
        newObject._frame = null;
        return newObject;
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.output.send(0, this._outputVal);
    }

    public Color getBackground() {
        return this._panel.getBackground();
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        if (this.slider == null) {
            int min = ((IntToken)this.minimum.getToken()).intValue();
            int max = ((IntToken)this.maximum.getToken()).intValue();
            int major = ((IntToken)this.majorTickSpacing.getToken()).intValue();
            int minor = ((IntToken)this.minorTickSpacing.getToken()).intValue();
            String titleSpec = this.title.getExpression();
            this._frame = new SliderFrame(min, max, major, minor, titleSpec);
            this._panel = (JPanel)this._frame.getContentPane().getComponent(0);
            this.slider = (JSlider)this._panel.getComponent(0);
            this.slider.addChangeListener(this);
        }
        if (this._frame != null) {
            this._frame.pack();
            this._frame.setVisible(true);
        }
    }

    @Override
    public void place(Container container) {
        this._container = container;
        if (this._container == null) {
            if (this._frame != null) {
                this._frame.dispose();
            }
            this._frame = null;
            this._panel = null;
            this.slider = null;
            return;
        }
        int min = -10;
        int max = 10;
        int major = 10;
        int minor = 1;
        String titleSpec = this.title.getExpression();
        try {
            min = ((IntToken)this.minimum.getToken()).intValue();
            max = ((IntToken)this.maximum.getToken()).intValue();
            major = ((IntToken)this.majorTickSpacing.getToken()).intValue();
            minor = ((IntToken)this.minorTickSpacing.getToken()).intValue();
        }
        catch (IllegalActionException ex) {
            // empty catch block
        }
        this._panel = SliderFrame.createSliderPanel(min, max, major, minor, titleSpec);
        this._container.add(this._panel);
        this._panel.setBackground(null);
        this._panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this._panel.setBorder(new LineBorder(Color.black));
        this.slider = (JSlider)this._panel.getComponent(0);
        this.slider.addChangeListener(this);
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        this._outputVal = new IntToken(this.slider.getValue());
        return super.prefire();
    }

    public void setBackground(Color background) {
        this._panel.setBackground(background);
    }

    @Override
    public void setContainer(CompositeEntity container) throws IllegalActionException, NameDuplicationException {
        super.setContainer(container);
        if (container == null) {
            this._remove();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this._val = this.slider.getValue();
    }

    private void _remove() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SliderSource.this.slider != null) {
                    if (SliderSource.this._container != null) {
                        SliderSource.this._container.remove(SliderSource.this._panel);
                        SliderSource.this._container.invalidate();
                        SliderSource.this._container.repaint();
                    } else if (SliderSource.this._frame != null) {
                        SliderSource.this._frame.dispose();
                    }
                }
            }
        });
    }

    public static class SliderFrame
    extends JFrame {
        private JSlider _slider;

        public SliderFrame(int minimum, int maximum, int majorTickSpacing, int minorTickSpacing, String title) {
            JPanel panel = SliderFrame.createSliderPanel(minimum, maximum, majorTickSpacing, minorTickSpacing, title);
            this._slider = (JSlider)panel.getComponent(0);
            this.getContentPane().add(panel);
            this.pack();
            this.setVisible(true);
        }

        public static JPanel createSliderPanel(int minimum, int maximum, int majorTickSpacing, int minorTickSpacing, String title) {
            JSlider slider = new JSlider(0, minimum, maximum, (maximum + minimum) / 2);
            slider.setBackground(null);
            slider.setMajorTickSpacing(majorTickSpacing);
            slider.setMinorTickSpacing(minorTickSpacing);
            slider.setPaintTicks(true);
            slider.setPaintLabels(true);
            JPanel panel = new JPanel();
            panel.add(slider);
            if (!title.trim().equals("")) {
                panel.setBorder(BorderFactory.createTitledBorder(title));
            }
            return panel;
        }

        public int getValue() {
            return this._slider.getValue();
        }
    }
}

