/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.SequenceActor;
import ptolemy.actor.lib.gui.Plotter;
import ptolemy.data.DoubleToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.plot.Plot;

public class SequencePlotter
extends Plotter
implements SequenceActor {
    public TypedIOPort input = new TypedIOPort(this, "input", true, false);
    public Parameter xUnit;
    public Parameter xInit;
    protected double _xValue;
    protected double _xInit;
    protected double _xUnit;
    boolean[] _connected;

    public SequencePlotter(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.input.setMultiport(true);
        this.input.setTypeEquals(BaseType.DOUBLE);
        this.xInit = new Parameter((NamedObj)this, "xInit", new DoubleToken(0.0));
        this.xInit.setTypeEquals(BaseType.DOUBLE);
        this.xUnit = new Parameter((NamedObj)this, "xUnit", new DoubleToken(1.0));
        this.xUnit.setTypeEquals(BaseType.DOUBLE);
        this.attributeChanged(this.xInit);
        this.attributeChanged(this.xUnit);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.xInit) {
            this._xInit = ((DoubleToken)this.xInit.getToken()).doubleValue();
        } else if (attribute == this.xUnit) {
            this._xUnit = ((DoubleToken)this.xUnit.getToken()).doubleValue();
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._xValue = this._xInit;
        int width = this.input.getWidth();
        this._connected = new boolean[width];
        for (int i = 0; i < width; ++i) {
            this._connected[i] = true;
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        int width = this.input.getWidth();
        int offset = ((IntToken)this.startingDataset.getToken()).intValue();
        for (int i = width - 1; i >= 0; --i) {
            if (!this.input.hasToken(i)) continue;
            DoubleToken curToken = (DoubleToken)this.input.get(i);
            if (curToken.isNil()) {
                this._connected[i] = false;
                continue;
            }
            double curValue = curToken.doubleValue();
            ((Plot)this.plot).addPoint(i + offset, this._xValue, curValue, this._connected[i]);
            this._connected[i] = true;
        }
        this._xValue += this._xUnit;
        return super.postfire();
    }
}

