/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.gui;

import ptolemy.actor.gui.Configuration;
import ptolemy.actor.gui.Effigy;
import ptolemy.actor.gui.PlotEffigy;
import ptolemy.actor.lib.gui.PlotterBase;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.plot.Plot;

public class Plotter
extends PlotterBase {
    public Parameter startingDataset = new Parameter((NamedObj)this, "startingDataset", new IntToken(0));

    public Plotter(CompositeEntity container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
        this.startingDataset.setTypeEquals(BaseType.INT);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.startingDataset) {
            if (((IntToken)this.startingDataset.getToken()).intValue() < 0) {
                throw new IllegalActionException((Nameable)this, "startingDataset: negative value is not allowed.");
            }
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        if (this.plot == null) {
            this.plot = this._newPlot();
            this.plot.setTitle(this.getName());
            this.plot.setButtons(true);
        }
        if (this._frame == null && this._container == null) {
            Effigy containerEffigy = Configuration.findEffigy(this.toplevel());
            if (containerEffigy == null) {
                throw new IllegalActionException((Nameable)this, "Cannot find effigy for top level: " + this.toplevel().getFullName());
            }
            try {
                PlotEffigy plotEffigy = new PlotEffigy(containerEffigy, containerEffigy.uniqueName("plot"));
                plotEffigy.identifier.setExpression(this.getFullName());
                PlotterBase.PlotWindowTableau tableau = new PlotterBase.PlotWindowTableau(this, plotEffigy, "tableau");
                this._frame = tableau.frame;
            }
            catch (Exception ex) {
                throw new IllegalActionException(this, null, ex, "Error creating effigy and tableau");
            }
            this._windowProperties.setProperties(this._frame);
            this._implementDeferredConfigurations();
            if (this._plotSize != null) {
                this._plotSize.setSize(this.plot);
            }
            this._frame.pack();
        } else if (this.plot instanceof Plot) {
            int width = ((Plot)this.plot).getNumDataSets();
            int offset = ((IntToken)this.startingDataset.getToken()).intValue();
            for (int i = width - 1; i >= 0; --i) {
                ((Plot)this.plot).clear(i + offset);
            }
            this.plot.repaint();
        } else {
            this.plot.clear(false);
            this.plot.repaint();
        }
        if (this._frame != null) {
            this._frame.show();
            this._frame.toFront();
        }
    }
}

