/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.lib.conversions.Converter;
import ptolemy.data.ArrayToken;
import ptolemy.data.StringToken;
import ptolemy.data.UnsignedByteToken;
import ptolemy.data.type.ArrayType;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class UnsignedByteArrayToString
extends Converter {
    public UnsignedByteArrayToString(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(new ArrayType(BaseType.UNSIGNED_BYTE));
        this.output.setTypeEquals(BaseType.STRING);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        ArrayToken dataArrayToken = (ArrayToken)this.input.get(0);
        byte[] dataBytes = new byte[dataArrayToken.length()];
        for (int j = 0; j < dataArrayToken.length(); ++j) {
            UnsignedByteToken dataToken = (UnsignedByteToken)dataArrayToken.getElement(j);
            dataBytes[j] = dataToken.byteValue();
        }
        String outputString = new String(dataBytes);
        this.output.send(0, new StringToken(outputString));
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.input.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

