/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.conversions;

import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.DoubleToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public class PolarToCartesian
extends TypedAtomicActor {
    public TypedIOPort magnitude = new TypedIOPort(this, "magnitude", true, false);
    public TypedIOPort angle;
    public TypedIOPort x;
    public TypedIOPort y;

    public PolarToCartesian(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.magnitude.setTypeEquals(BaseType.DOUBLE);
        this.angle = new TypedIOPort(this, "angle", true, false);
        this.angle.setTypeEquals(BaseType.DOUBLE);
        this.x = new TypedIOPort(this, "x", false, true);
        this.x.setTypeEquals(BaseType.DOUBLE);
        this.y = new TypedIOPort(this, "y", false, true);
        this.y.setTypeEquals(BaseType.DOUBLE);
        this._attachText("_iconDescription", "<svg>\n<polygon points=\"-15,-15 15,15 15,-15 -15,15\" style=\"fill:white\"/>\n</svg>\n");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        double magnitudeValue = ((DoubleToken)this.magnitude.get(0)).doubleValue();
        double angleValue = ((DoubleToken)this.angle.get(0)).doubleValue();
        double xValue = magnitudeValue * Math.cos(angleValue);
        double yValue = magnitudeValue * Math.sin(angleValue);
        this.x.send(0, new DoubleToken(xValue));
        this.y.send(0, new DoubleToken(yValue));
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        if (!this.magnitude.hasToken(0) || !this.angle.hasToken(0)) {
            return false;
        }
        return super.prefire();
    }
}

