/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class HammingCoder
extends Transformer {
    public Parameter uncodedRate = new Parameter(this, "uncodedRate");
    public Parameter codedRate;
    private Parameter _inputRate;
    private Parameter _outputRate;
    private int _uncodeSizeValue;
    private int _codeSizeValue;
    private int _order;
    private int[][] _parityMatrix;
    private transient boolean _parameterInvalid = true;

    public HammingCoder(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.uncodedRate.setTypeEquals(BaseType.INT);
        this.uncodedRate.setExpression("4");
        this.codedRate = new Parameter(this, "codedRate");
        this.codedRate.setTypeEquals(BaseType.INT);
        this.codedRate.setExpression("7");
        this.input.setTypeEquals(BaseType.BOOLEAN);
        this._inputRate = new Parameter((NamedObj)this.input, "tokenConsumptionRate", new IntToken(1));
        this.output.setTypeEquals(BaseType.BOOLEAN);
        this._outputRate = new Parameter((NamedObj)this.output, "tokenProductionRate", new IntToken(1));
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.codedRate) {
            this._codeSizeValue = ((IntToken)this.codedRate.getToken()).intValue();
            if (this._codeSizeValue <= 0) {
                throw new IllegalActionException((Nameable)this, "codedRate must be positive.");
            }
            this._outputRate.setToken(new IntToken(this._codeSizeValue));
        } else if (attribute == this.uncodedRate) {
            this._uncodeSizeValue = ((IntToken)this.uncodedRate.getToken()).intValue();
            if (this._uncodeSizeValue < 1) {
                throw new IllegalActionException((Nameable)this, "uncodedRate must be non-negative.");
            }
            this._parameterInvalid = true;
            this._inputRate.setToken(new IntToken(this._uncodeSizeValue));
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        int i;
        int i2;
        super.fire();
        if (this._parameterInvalid) {
            if (this._uncodeSizeValue >= this._codeSizeValue) {
                throw new IllegalActionException((Nameable)this, "codedRate must be greater than uncodedRate.");
            }
            this._order = this._codeSizeValue - this._uncodeSizeValue;
            if (this._codeSizeValue != (1 << this._order) - 1) {
                throw new IllegalActionException((Nameable)this, "Invalid pair of uncodedRate and codedRate.");
            }
            this._parityMatrix = new int[this._uncodeSizeValue][this._order];
            int flag = 0;
            int index = 0;
            for (i2 = 1; i2 <= this._codeSizeValue; ++i2) {
                if (i2 == 1 << flag) {
                    ++flag;
                    continue;
                }
                for (int j = 0; j < this._order; ++j) {
                    this._parityMatrix[index][j] = i2 >> this._order - j - 1 & 1;
                }
                ++index;
            }
            this._parameterInvalid = false;
        }
        Token[] inputToken = this.input.get(0, this._uncodeSizeValue);
        Token[] result = new BooleanToken[this._codeSizeValue];
        for (i2 = 0; i2 < this._uncodeSizeValue; ++i2) {
            result[i2] = (BooleanToken)inputToken[i2];
        }
        int[] parity = new int[this._order];
        for (i = 0; i < this._order; ++i) {
            parity[i] = 0;
        }
        for (i = 0; i < this._uncodeSizeValue; ++i) {
            for (int j = 0; j < this._order; ++j) {
                parity[j] = parity[j] ^ (((BooleanToken)result[i]).booleanValue() ? 1 : 0) & this._parityMatrix[i][j];
            }
        }
        for (i = 0; i < this._order; ++i) {
            result[i + this._uncodeSizeValue] = new BooleanToken(parity[i] == 1);
        }
        this.output.broadcast(result, result.length);
    }
}

