/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib.comm;

import ptolemy.actor.lib.Source;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.IntToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class HadamardCode
extends Source {
    public PortParameter index = new PortParameter(this, "index");
    public Parameter log2Length;
    private int _index;
    private int _previousIndex;
    private int _latestIndex;
    private boolean[] _row;
    private static boolean[] _row0 = new boolean[]{true, true};
    private static boolean[] _row1 = new boolean[]{true, false};
    private transient boolean _rowValueInvalid = true;

    public HadamardCode(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.index.setTypeEquals(BaseType.INT);
        this.index.setExpression("0");
        this.log2Length = new Parameter(this, "log2Length");
        this.log2Length.setTypeEquals(BaseType.INT);
        this.log2Length.setExpression("5");
        this.output.setTypeEquals(BaseType.BOOLEAN);
    }

    @Override
    public void attributeChanged(Attribute attribute) throws IllegalActionException {
        if (attribute == this.index) {
            int indexValue = ((IntToken)this.index.getToken()).intValue();
            if (indexValue < 0) {
                throw new IllegalActionException((Nameable)this, "index parameter is not permitted to be negative.");
            }
            if (indexValue != this._previousIndex) {
                this._rowValueInvalid = true;
            }
        } else if (attribute == this.log2Length) {
            int log2LengthValue = ((IntToken)this.log2Length.getToken()).intValue();
            if (log2LengthValue <= 0) {
                throw new IllegalActionException((Nameable)this, "log2Length parameter is required to be strictly positive.");
            }
            if (log2LengthValue >= 32) {
                throw new IllegalActionException((Nameable)this, "log2Length parameter is required to be less than 32.");
            }
            this._rowValueInvalid = true;
        } else {
            super.attributeChanged(attribute);
        }
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        this.index.update();
        if (this._rowValueInvalid) {
            this._latestIndex = ((IntToken)this.index.getToken()).intValue();
            int log2LengthValue = ((IntToken)this.log2Length.getToken()).intValue();
            int matrixDimension = 1 << log2LengthValue;
            if (this._latestIndex >= matrixDimension) {
                throw new IllegalActionException((Nameable)this, "index is out of range.");
            }
            this._row = this._calculateRow(matrixDimension, this._latestIndex);
            this._rowValueInvalid = false;
            this._index = 0;
        }
        this.output.broadcast(new BooleanToken(this._row[this._index]));
        ++this._index;
        if (this._index >= this._row.length) {
            this._index = 0;
        }
    }

    @Override
    public void initialize() throws IllegalActionException {
        super.initialize();
        this._previousIndex = -1;
        this._index = 0;
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._previousIndex = this._latestIndex;
        return super.postfire();
    }

    private boolean[] _calculateRow(int matrixDimension, int index) {
        if (matrixDimension <= 2) {
            if (index == 0) {
                return _row0;
            }
            return _row1;
        }
        boolean[] result = new boolean[matrixDimension];
        int halfDimension = matrixDimension / 2;
        int indexIntoHalfMatrix = index;
        if (index >= halfDimension) {
            indexIntoHalfMatrix -= halfDimension;
        }
        boolean[] halfRow = this._calculateRow(halfDimension, indexIntoHalfMatrix);
        System.arraycopy(halfRow, 0, result, 0, halfDimension);
        if (index >= halfDimension) {
            for (int i = 0; i < halfDimension; ++i) {
                result[halfDimension + i] = !halfRow[i];
            }
        } else {
            System.arraycopy(halfRow, 0, result, halfDimension, halfDimension);
        }
        return result;
    }
}

