/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.Transformer;
import ptolemy.data.DoubleMatrixToken;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;

public class VectorDisassembler
extends Transformer {
    public VectorDisassembler(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.input.setTypeEquals(BaseType.DOUBLE_MATRIX);
        this.input.setMultiport(false);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.output.setMultiport(true);
        this._attachText("_iconDescription", "<svg>\n<rect x=\"0\" y=\"0\" width=\"6\" height=\"40\" style=\"fill:blue\"/>\n</svg>\n");
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (this.input.hasToken(0)) {
            DoubleMatrixToken vector = (DoubleMatrixToken)this.input.get(0);
            if (vector.getColumnCount() == 1) {
                int min = Math.min(vector.getRowCount(), this.output.getWidth());
                for (int i = 0; i < min; ++i) {
                    this.output.send(i, vector.getElementAsToken(i, 0));
                }
            } else if (vector.getRowCount() == 1) {
                int min = Math.min(vector.getColumnCount(), this.output.getWidth());
                for (int i = 0; i < min; ++i) {
                    this.output.send(i, vector.getElementAsToken(0, i));
                }
            } else {
                throw new IllegalActionException((Nameable)this, "The input must be a DoubleMatrixToken with one column or row. But the input is " + vector);
            }
        }
    }
}

