/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Transformer;
import ptolemy.data.LongToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class VariableSleep
extends Transformer {
    public Parameter defaultSleepTime = new Parameter((NamedObj)this, "defaultSleepTime", new LongToken(0L));
    public TypedIOPort sleepTime;
    private boolean _wasSleepCalledInFireYet = false;
    private long _sleepTime;

    public VariableSleep(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.defaultSleepTime.setTypeEquals(BaseType.LONG);
        this.input.setMultiport(true);
        this.output.setMultiport(true);
        this.sleepTime = new TypedIOPort(this, "sleepTime", true, false);
        this.sleepTime.setTypeEquals(BaseType.LONG);
    }

    @Override
    public void fire() throws IllegalActionException {
        super.fire();
        if (!this._wasSleepCalledInFireYet) {
            try {
                this._sleepTime = this.sleepTime.hasToken(0) ? ((LongToken)this.sleepTime.get(0)).longValue() : ((LongToken)this.defaultSleepTime.getToken()).longValue();
                if (this._debugging) {
                    this._debug(this.getName() + ": Wait for " + this._sleepTime + " milliseconds.");
                }
                Thread.sleep(this._sleepTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int inputWidth = this.input.getWidth();
            int outputWidth = this.output.getWidth();
            for (int i = 0; i < inputWidth; ++i) {
                if (!this.input.hasToken(i)) continue;
                Token inToken = this.input.get(i);
                if (i >= outputWidth) continue;
                this.output.send(i, inToken);
            }
        }
    }

    @Override
    public boolean postfire() throws IllegalActionException {
        this._wasSleepCalledInFireYet = false;
        return super.postfire();
    }

    @Override
    public boolean prefire() throws IllegalActionException {
        this._wasSleepCalledInFireYet = false;
        return super.prefire();
    }
}

