/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.actor.lib;

import ptolemy.actor.lib.RandomSource;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.BooleanToken;
import ptolemy.data.DoubleToken;
import ptolemy.data.expr.SingletonParameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;

public class Triangular
extends RandomSource {
    public PortParameter min;
    public PortParameter max;
    public PortParameter mode;
    private double _current;

    public Triangular(CompositeEntity container, String name) throws NameDuplicationException, IllegalActionException {
        super(container, name);
        this.output.setTypeEquals(BaseType.DOUBLE);
        this.mode = new PortParameter((NamedObj)this, "mode", new DoubleToken(0.5));
        this.mode.setTypeEquals(BaseType.DOUBLE);
        new SingletonParameter(this.mode.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.min = new PortParameter((NamedObj)this, "min", new DoubleToken(0.0));
        this.min.setTypeEquals(BaseType.DOUBLE);
        new SingletonParameter(this.min.getPort(), "_showName").setToken(BooleanToken.TRUE);
        this.max = new PortParameter((NamedObj)this, "max", new DoubleToken(1.0));
        this.max.setTypeEquals(BaseType.DOUBLE);
        new SingletonParameter(this.max.getPort(), "_showName").setToken(BooleanToken.TRUE);
    }

    @Override
    public void fire() throws IllegalActionException {
        this.mode.update();
        this.min.update();
        this.max.update();
        super.fire();
        this.output.send(0, new DoubleToken(this._current));
    }

    @Override
    protected void _generateRandomNumber() throws IllegalActionException {
        double minValue = ((DoubleToken)this.min.getToken()).doubleValue();
        double maxValue = ((DoubleToken)this.max.getToken()).doubleValue();
        double modeValue = ((DoubleToken)this.mode.getToken()).doubleValue();
        if (minValue > maxValue) {
            throw new IllegalActionException((Nameable)this, "Invalid bounds: min is greater than max.");
        }
        if (modeValue < minValue) {
            throw new IllegalActionException((Nameable)this, "Invalid bounds: mode is less than min.");
        }
        if (modeValue > maxValue) {
            throw new IllegalActionException((Nameable)this, "Invalid bounds: mode is greater than max.");
        }
        double rawNum = this._random.nextDouble();
        double left = modeValue - minValue;
        double whole = maxValue - minValue;
        double right = maxValue - modeValue;
        this._current = rawNum <= left / whole ? minValue + Math.sqrt(rawNum * whole * left) : maxValue - Math.sqrt((1.0 - rawNum) * whole * right);
    }
}

